/*
 * Decompiled with CFR 0.152.
 */
package org.ytboymc.SrvStatus;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import org.bukkit.Bukkit;

public class SrvStatusApp {
    private JDA jda;
    private String channelId;
    private String onlineMessage;
    private String offlineMessage;
    private String embedTitle;
    private Color onlineColor;
    private Color offlineColor;
    private String onlineFooter;
    private String offlineFooter;

    public SrvStatusApp(File dataFolder) throws IOException {
        Map<String, String> config;
        String botToken;
        File configFile = new File(dataFolder, "Config.yml");
        if (!configFile.exists()) {
            // empty if block
        }
        if ((botToken = (config = this.parseConfig(configFile)).get("TOKEN")) == null || botToken.equals("0000")) {
            Bukkit.getLogger().severe("Config Error: TOKEN Is Missing Or Un Configured, Update Config.yml!");
            return;
        }
        this.channelId = config.get("ChannelID");
        this.onlineMessage = config.get("Online");
        this.offlineMessage = config.get("Offline");
        this.embedTitle = config.get("Title");
        this.onlineColor = this.parseColor(config.get("OnlineColor"));
        this.offlineColor = this.parseColor(config.get("OfflineColor"));
        this.onlineFooter = config.get("OnlineFooter");
        this.offlineFooter = config.get("OfflineFooter");
        try {
            this.jda = JDABuilder.createDefault(botToken).setEnableShutdownHook(false).build();
            this.jda.awaitReady();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Java Discord API - JDA Initialization Failed Due To An Error: " + e.getMessage());
        }
    }

    public void AppStartup() {
        this.sendEmbedMessage(this.onlineMessage, this.onlineColor, this.onlineFooter);
    }

    public void AppShutdown() {
        this.sendEmbedMessage(this.offlineMessage, this.offlineColor, this.offlineFooter);
    }

    private void sendEmbedMessage(String description, Color color, String footer) {
        if (this.jda == null || this.channelId == null || this.channelId.isEmpty()) {
            Bukkit.getLogger().severe("The ChannelID Is Empty Or Invalid, Please Insure Its Correct And The Field ChannelId Inside Config.yml Is Not Empty!");
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            EmbedBuilder embed = new EmbedBuilder().setTitle(this.embedTitle).setDescription(description).setColor(color).setFooter(footer);
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        } else {
            Bukkit.getLogger().severe("The ChannelID Is Invalid, Please Insure That The ChannelID In The ChannelID Field Inside Config.yml Has The Correct ChannelID Included!");
        }
    }

    private Map<String, String> parseConfig(File configFile) throws IOException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        List<String> lines = Files.readAllLines(configFile.toPath());
        for (String line : lines) {
            if (!line.contains(":")) continue;
            String[] parts = line.split(":", 2);
            String key = parts[0].trim();
            String value = parts[1].trim().replace("\"", "");
            configMap.put(key, value);
        }
        return configMap;
    }

    private Color parseColor(String colorName) {
        if (colorName == null || colorName.isEmpty()) {
            return Color.WHITE;
        }
        switch (colorName.toLowerCase()) {
            case "red": {
                return Color.RED;
            }
            case "green": {
                return Color.GREEN;
            }
            case "blue": {
                return Color.BLUE;
            }
            case "yellow": {
                return Color.YELLOW;
            }
            case "cyan": {
                return Color.CYAN;
            }
            case "magenta": {
                return Color.MAGENTA;
            }
            case "orange": {
                return Color.ORANGE;
            }
            case "pink": {
                return Color.PINK;
            }
        }
        return Color.WHITE;
    }
}

