/*
 * Decompiled with CFR 0.152.
 */
package it.reloia.tecnogui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.config.v2.impl.serializer.GsonConfigSerializer;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import org.jetbrains.annotations.NotNull;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new GsonConfigSerializer.ColorTypeAdapter()).create();
    private static final File CONFIG_FILE = new File("config/tecnogui.json");
    private boolean shouldHideVoteAds = false;
    private boolean shouldHideEnteredPlotMsg = false;
    private boolean shouldHighlightExpiredFood = true;
    private boolean shouldHideScoreboard = true;
    private Color highlightExpiredFoodColor = new Color(-2137985392);

    public boolean isHideVoteAds() {
        return this.shouldHideVoteAds;
    }

    public void setHideVoteAds(boolean hideBossBarName) {
        this.shouldHideVoteAds = hideBossBarName;
    }

    public boolean isHideEnteredPlotMsg() {
        return this.shouldHideEnteredPlotMsg;
    }

    public void setHideEnteredPlotMsg(boolean hideEnteredPlotMsg) {
        this.shouldHideEnteredPlotMsg = hideEnteredPlotMsg;
    }

    public boolean isHighlightExpiredFood() {
        return this.shouldHighlightExpiredFood;
    }

    public void setHighlightExpiredFood(boolean highlightExpiredFood) {
        this.shouldHighlightExpiredFood = highlightExpiredFood;
    }

    public boolean isHideScoreboard() {
        return this.shouldHideScoreboard;
    }

    public void setHideScoreboard(boolean hideScoreboard) {
        this.shouldHideScoreboard = hideScoreboard;
    }

    public Color getHighlightExpiredFoodColor() {
        return this.highlightExpiredFoodColor;
    }

    public void setHighlightExpiredFoodColor(@NotNull Color color) {
        this.highlightExpiredFoodColor = color;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config load() {
        if (!CONFIG_FILE.exists()) {
            return new Config();
        }
        try {
            return (Config)GSON.fromJson(Files.readString(CONFIG_FILE.toPath()), Config.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Config();
        }
    }
}

