/*
 * Decompiled with CFR 0.152.
 */
package it.reloia.tecnogui.dataparsing;

import it.reloia.tecnogui.dataparsing.Utils;
import it.reloia.tecnogui.dataparsing.data.SidebarData;
import it.reloia.tecnogui.dataparsing.food.FoodSaturationCalculator;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TecnoData {
    private static final Logger LOGGER = LogManager.getLogger(TecnoData.class);
    public static final TecnoData INSTANCE = new TecnoData();
    private static final int ONE_SECOND = 20;
    private static final int TEN_SECONDS = 200;
    private static final int HEALTH_SLOT = 3;
    private int tickCounter = 0;
    private SidebarData sidebarData = null;
    public float hydration = 0.0f;
    private List<String> sidebarLines = Collections.emptyList();
    public boolean loadingBalance = false;
    public String fullBalance = "Loading...";
    public String healthStatus = "Loading...";
    public boolean inAServer = false;
    public boolean isInTecnoRoleplay = false;
    public boolean isHUDEnabled = true;
    public float heldHydration = 0.0f;
    public float heldSaturation = 0.0f;

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter % 20 == 0) {
            this.fetchSidebarLines();
            this.checkIfInTecnoRoleplay();
            if (this.inAServer && this.isInTecnoRoleplay && this.sidebarLines.size() >= 14) {
                this.sidebarData = SidebarData.fromLines(this.sidebarLines);
            }
        }
        if (this.tickCounter % 200 == 0 && this.inAServer && this.isInTecnoRoleplay) {
            this.loadBalance();
            this.loadHealthStatus();
        }
        if (this.tickCounter > 1000) {
            this.tickCounter = 0;
        }
    }

    public SidebarData getSidebarData() {
        return this.sidebarData;
    }

    private TecnoData() {
    }

    private void fetchSidebarLines() {
        this.sidebarLines = Utils.getSidebarLines();
    }

    private void loadBalance() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1562() == null) {
            return;
        }
        this.loadingBalance = true;
        client.method_1562().method_45731("balance");
    }

    private void loadHealthStatus() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        if (client.field_1724.field_7512 == null || client.field_1724.field_7512.field_7761.size() < 4) {
            return;
        }
        class_1799 healthStack = ((class_1735)client.field_1724.field_7512.field_7761.get(3)).method_7677();
        if (healthStack.method_7960()) {
            this.healthStatus = "Loading...";
        } else if (healthStack.method_7950((class_1657)client.field_1724, (class_1836)class_1836.field_41070).size() > 1) {
            this.healthStatus = ((class_2561)healthStack.method_7950((class_1657)client.field_1724, (class_1836)class_1836.field_41070).get(1)).getString();
        } else {
            LOGGER.error("Error while parsing health status. + {}", (Object)healthStack.method_7950((class_1657)client.field_1724, (class_1836)class_1836.field_41070));
        }
    }

    private void checkIfInTecnoRoleplay() {
        this.isInTecnoRoleplay = this.sidebarLines.size() >= 3 ? this.sidebarLines.get(3).contains("\u1d04\u1d0f\u1d0f\u0280\u1d05\u026a\u0274\u1d00\u1d1b\u1d07") : false;
    }

    public void loadHeldStatus(int slot) {
        class_310 client = class_310.method_1551();
        this.heldHydration = 0.0f;
        this.heldSaturation = 0.0f;
        if (client == null || client.field_1724 == null) {
            return;
        }
        if (client.field_1724.method_31548() == null || client.field_1724.method_31548().method_5438(slot).method_7960()) {
            return;
        }
        class_1792 heldItem = client.field_1724.method_31548().method_5438(slot).method_7909();
        if (heldItem.method_19263()) {
            this.heldSaturation = FoodSaturationCalculator.calculateSaturation(client.field_1724.method_31548().method_5438(slot));
        }
        if (heldItem instanceof class_1812) {
            this.heldHydration = 4.0f;
        }
    }
}

