/*
 * Decompiled with CFR 0.152.
 */
package io.github.rulft44.druids.datagen;

import io.github.rulft44.druids.datagen.DruidRecipes;
import io.github.rulft44.druids.item.ModArmors;
import io.github.rulft44.druids.item.ModWeapons;
import io.github.rulft44.druids.spell.DruidSpells;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class DruidsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(DruidRecipes::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, ModArmors.druidArmorSet, class_1802.field_8317);
            UnsmeltGenerator.disassembleArmor(exporter, ModArmors.netheriteDruidArmorSet, class_1802.field_22021);
            UnsmeltGenerator.disassemble(exporter, List.of(ModWeapons.natureWand.item()), class_1802.field_8665);
            UnsmeltGenerator.disassemble(exporter, List.of(ModWeapons.natureStaff.item()), class_1802.field_8687);
            UnsmeltGenerator.disassemble(exporter, ModWeapons.entries.stream().filter(entry -> entry.id().method_12832().contains("netherite")).map(entry -> entry.item()).toList(), class_1802.field_22021);
        }

        private static void disassemble(class_8790 exporter, List<class_1935> items, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassembleArmor(class_8790 exporter, Armor.Set armorSet, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateArmorTags(ModArmors.entries, RPGSeriesItemTags.ArmorMetaType.MAGIC);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (DruidSpells.Entry entry : DruidSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

