/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg;

import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.raynna.raynnarpg.Config;
import net.raynna.raynnarpg.IProxy;
import net.raynna.raynnarpg.SideProxy;
import net.raynna.raynnarpg.client.ui.OverlayManager;
import org.slf4j.Logger;

@Mod(value="raynnarpg")
public class RaynnaRPG {
    public static final String MOD_ID = "raynnarpg";
    public static final String MOD_NAME = "Raynna's RPG";
    public static final String RESOURCE_PREFIX = "raynnarpg:";
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static RaynnaRPG INSTANCE;
    public static IProxy PROXY;
    @OnlyIn(value=Dist.CLIENT)
    private static OverlayManager clientOverlayManager;

    @OnlyIn(value=Dist.CLIENT)
    public static OverlayManager getOverlayManager() {
        if (clientOverlayManager == null) {
            clientOverlayManager = new OverlayManager();
        }
        return clientOverlayManager;
    }

    public RaynnaRPG(IEventBus modEventBus, ModContainer modContainer) {
        INSTANCE = this;
        PROXY = FMLEnvironment.dist == Dist.CLIENT ? new SideProxy.Client(modEventBus, modContainer) : new SideProxy.Server(modEventBus, modContainer);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.Server.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation getId(String path) {
        if (path.contains(":")) {
            if (path.startsWith(MOD_ID)) {
                return ResourceLocation.tryParse((String)path);
            }
            throw new IllegalArgumentException("path contains namespace other than raynnarpg");
        }
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("[RaynnaRPG] Mod loaded on dedicated server]");
    }

    @EventBusSubscriber(modid="raynnarpg", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("[RaynnaRPG] Mod loaded on client]");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

