/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.client.events;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.raynna.raynnarpg.client.player.ClientSkills;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.combat.CombatConfig;
import net.raynna.raynnarpg.config.crafting.CraftingConfig;
import net.raynna.raynnarpg.config.mining.MiningConfig;
import net.raynna.raynnarpg.config.smelting.SmeltingConfig;
import net.raynna.raynnarpg.config.tools.ToolConfig;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.SilentGearHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroups;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.Color;
import org.lwjgl.glfw.GLFW;

public class ClientItemEvents {
    private static boolean shouldProcessTooltip(ItemTooltipEvent event) {
        return event.getEntity() == null || event.getEntity().isAlive();
    }

    private static double getAttackRange(LivingEntity entity) {
        ItemStack stack = entity.getMainHandItem();
        double base = GearHelper.getType((ItemStack)stack).matches((GearType)GearTypes.TOOL.get()) ? (double)GearData.getProperties((ItemStack)stack).getNumber(GearProperties.ATTACK_REACH) : (double)((Float)((NumberProperty)GearProperties.ATTACK_REACH.get()).getBaseValue()).floatValue();
        AttributeInstance attribute = entity.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attribute != null) {
            double reachBonus = attribute.getValue() - attribute.getBaseValue();
            return base + reachBonus;
        }
        return base;
    }

    private static float getTraitModifiedMiningSpeed(ItemStack stack, BlockState state, float baseSpeed) {
        float totalModifier = 0.0f;
        for (TraitInstance traitInstance : TraitHelper.getTraits((ItemStack)stack)) {
            totalModifier += traitInstance.getTrait().getMiningSpeedModifier(traitInstance.getLevel(), state, baseSpeed);
        }
        return baseSpeed * (1.0f + totalModifier);
    }

    private static void addStatsTooltip(TooltipContext context) {
        double attackRange;
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        EquipmentSlot slot = ClientItemEvents.getAppropriateSlot(context.stack);
        ItemStack equippedStack = ClientItemEvents.getCurrentlyEquippedItem((Entity)context.event.getEntity(), slot);
        double attackDamage = ClientItemEvents.getItemAttackDamage(context.stack);
        if (attackDamage > 0.0) {
            double equippedDamage = ClientItemEvents.getItemAttackDamage(equippedStack);
            String comparison = ClientItemEvents.getComparisonString(attackDamage, equippedDamage);
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a76Attack Damage: \u00a7f" + String.format("%.1f", attackDamage) + comparison)));
        }
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && context.event.getEntity() != null && SilentGearHelper.isWeapon(context.stack) && (attackRange = ClientItemEvents.getAttackRange((LivingEntity)context.event.getEntity())) > 0.0) {
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a76Attack Range: " + String.format("%.1f", attackRange))));
        }
    }

    private static double getItemAttackDamage(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0.0;
        }
        if (SilentGearHelper.isSilentGearLoaded() && stack.getItem() instanceof GearItem) {
            return GearHelper.getAttackDamageModifier((ItemStack)stack);
        }
        return ClientItemEvents.getAttributeValue(stack, (ResourceKey<Attribute>)Attributes.ATTACK_DAMAGE.getKey());
    }

    private static double getItemAttackReach(TooltipContext context) {
        if (context.stack.isEmpty()) {
            return 0.0;
        }
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem) {
            return context.event.getEntity() != null ? ClientItemEvents.getAttackRange((LivingEntity)context.event.getEntity()) : 0.0;
        }
        return ClientItemEvents.getAttributeValue(context.stack, (ResourceKey<Attribute>)Attributes.ENTITY_INTERACTION_RANGE.getKey());
    }

    private static EquipmentSlot getAppropriateSlot(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }

    private static ItemStack getCurrentlyEquippedItem(Entity entity, EquipmentSlot slot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (slot == EquipmentSlot.MAINHAND) {
                return player.getInventory().getSelected();
            }
            return player.getItemBySlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private static double getAttributeValue(ItemStack stack, ResourceKey<Attribute> attribute) {
        if (stack.isEmpty()) {
            return 0.0;
        }
        return stack.getAttributeModifiers().modifiers().stream().filter(e -> e.attribute().is(attribute)).mapToDouble(e -> e.modifier().amount()).findFirst().orElse(0.0);
    }

    private static String getComparisonString(double newValue, double equippedValue) {
        if (equippedValue <= 0.0) {
            return "";
        }
        double diff = newValue - equippedValue;
        if (diff > 0.0) {
            return "\u00a7a (+" + String.format("%.1f", diff) + ")";
        }
        if (diff < 0.0) {
            return "\u00a7c (" + String.format("%.1f", diff) + ")";
        }
        return "\u00a77 (=)";
    }

    private static void checkTraits(TooltipContext context, Map<String, String> descriptions) {
        List traits;
        ItemStack stack = context.stack;
        if (SilentGearHelper.isSilentGearLoaded() && stack.getItem() instanceof GearItem && !(traits = GearData.getProperties((ItemStack)stack).getTraits()).isEmpty()) {
            StringBuilder traitsLine = new StringBuilder("\u00a76  Traits: ");
            boolean first = true;
            for (TraitInstance trait : traits) {
                if (!first) {
                    traitsLine.append("\u00a77, ");
                }
                first = false;
                String name = trait.getTrait().getDisplayName(trait.getLevel()).getString();
                traitsLine.append("\u00a7f").append(name);
                String desc = trait.getTrait().getDescription(trait.getLevel()).getString();
                descriptions.put(name, "\u00a77" + desc);
            }
            descriptions.put("TRAITS_LINE", traitsLine.toString());
        }
    }

    private static void checkEnchants(TooltipContext context, Map<String, String> enchants) {
        ItemEnchantments enchantments;
        ItemStack stack = context.stack;
        if (stack.isEnchanted() && !(enchantments = stack.getTagEnchantments()).keySet().isEmpty()) {
            StringBuilder enchantmentsLine = new StringBuilder("\u00a7dEnchantments: ");
            boolean first = true;
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                if (!first) {
                    enchantmentsLine.append("\u00a77, ");
                }
                first = false;
                Enchantment enchant = (Enchantment)((Holder)entry.getKey()).value();
                int level = entry.getIntValue();
                String name = enchant.description().getString();
                enchantmentsLine.append("\u00a7f").append(name).append(" ").append(level);
                String description = ClientItemEvents.getEnchantmentDescription(name, level);
                enchants.put("\u00a7f" + name + " " + level, "\u00a77" + description);
            }
            enchants.put("ENCHANTMENT_LINES", enchantmentsLine.toString());
        }
    }

    private static void checkFoodEffects(TooltipContext context, Map<String, String> foodDescription) {
        FoodProperties foodProps;
        ItemStack stack = context.stack;
        if (!stack.isEmpty() && (foodProps = stack.getItem().getFoodProperties(stack, null)) != null) {
            StringBuilder effectLine = new StringBuilder();
            List effects = foodProps.effects();
            String nutrition = String.valueOf(foodProps.nutrition());
            String saturdation = String.format("%.1f", Float.valueOf(foodProps.saturation()));
            saturdation = saturdation.replace(".0", "");
            effectLine.append("\u2764").append(": ").append(nutrition).append(", ").append("\ud83c\udf57").append(": ").append(saturdation);
            if (!effects.isEmpty()) {
                boolean first = true;
                effectLine.append("\u00a7d").append("\nEffects: ");
                for (FoodProperties.PossibleEffect effectPair : effects) {
                    if (!first) {
                        effectLine.append("\u00a77, ");
                    }
                    first = false;
                    MobEffectInstance effect = effectPair.effect();
                    float probability = effectPair.probability();
                    String effectName = ((MobEffect)effect.getEffect().value()).getDisplayName().getString();
                    String duration = MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)20.0f).getString();
                    String amplifier = ClientItemEvents.getAmplifierString(effect.getAmplifier());
                    effectLine.append("\u00a7f").append(effectName);
                    if (!amplifier.isEmpty()) {
                        effectLine.append(" ").append(amplifier);
                    }
                    effectLine.append("\u00a77").append(" (").append(duration).append(")");
                    if (!(probability < 1.0f)) continue;
                    effectLine.append("\u00a77").append(" ").append((int)(probability * 100.0f)).append("% chance");
                }
            }
            foodDescription.put("FOOD_LINE", effectLine.toString());
        }
    }

    private static String getAmplifierString(int amplifier) {
        if (amplifier <= 0) {
            return "";
        }
        return switch (amplifier) {
            case 1 -> "II";
            case 2 -> "III";
            case 3 -> "IV";
            case 4 -> "V";
            default -> "[" + (amplifier + 1) + "]";
        };
    }

    private static void checkMiningRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = MiningConfig.getMiningData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientItemEvents.formatRequirement(level, data));
        }
    }

    private static void checkCraftingRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = CraftingConfig.getCraftingData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.CRAFTING);
            requirements.put("Crafting", ClientItemEvents.formatRequirement(level, data));
        }
    }

    private static void checkSmeltingRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = SmeltingConfig.getSmeltingData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.SMELTING);
            requirements.put("Smelting", ClientItemEvents.formatRequirement(level, data));
        }
    }

    private static void checkToolRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData toolData;
        String harvestTier;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isPickaxe(context.stack) && (data = ToolConfig.getSilentGearData(harvestTier = SilentGearHelper.getGearProperty(context.stack, (GearProperty)GearProperties.HARVEST_TIER.get()))) != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientItemEvents.formatToolRequirement(level, data));
        }
        if ((toolData = ToolConfig.getToolData(context.stack)) != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientItemEvents.formatToolRequirement(level, toolData));
        }
    }

    private static void checkArmourRequirement(TooltipContext context, Map<String, String> requirements) {
        ConfigData armourData;
        int level;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isArmor(context.stack) && (data = CombatConfig.getData(context.stack, true)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientItemEvents.formatCombatRequirement(level, data));
        }
        if ((armourData = CombatConfig.getData(context.stack, true)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientItemEvents.formatCombatRequirement(level, armourData));
        }
    }

    private static void checkWeaponRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData armourData;
        int level;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isWeapon(context.stack) && (data = CombatConfig.getData(context.stack, false)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientItemEvents.formatCombatRequirement(level, data));
        }
        if ((armourData = CombatConfig.getData(context.stack, false)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientItemEvents.formatCombatRequirement(level, armourData));
        }
    }

    private static String getEnchantmentDescription(String enchantName, int level) {
        switch (enchantName.toLowerCase()) {
            case "protection": {
                return String.format("Reduces all damage by %d%% (4%% per level)", level * 4);
            }
            case "fire protection": {
                return String.format("Reduces fire damage by %d%% (8%% per level)", level * 8);
            }
            case "feather falling": {
                return String.format("Reduces fall damage by %d%% (12%% per level)", level * 12);
            }
            case "blast protection": {
                return String.format("Reduces explosion damage by %d%% (8%% per level)", level * 8);
            }
            case "projectile protection": {
                return String.format("Reduces projectile damage by %d%% (8%% per level)", level * 8);
            }
            case "thorns": {
                return String.format("%d%% chance to damage attackers (15%% per level)", level * 15);
            }
            case "depth strider": {
                return String.format("Increases underwater speed by %d%% (33%% per level)", level * 33);
            }
            case "soul speed": {
                return String.format("Increases speed on soul sand by %d%% (30%% per level)", level * 30);
            }
            case "swift sneak": {
                return String.format("Increases sneak speed by %d%% (15%% per level)", level * 15);
            }
            case "sharpness": {
                return String.format("+%.1f damage (1.25 per level)", (double)level * 1.25);
            }
            case "smite": {
                return String.format("+%.1f damage vs undead (2.5 per level)", (double)level * 2.5);
            }
            case "bane of arthropods": {
                return String.format("+%.1f damage vs arthropods (2.5 per level)", (double)level * 2.5);
            }
            case "knockback": {
                return String.format("Adds %d blocks knockback (3 per level)", level * 3);
            }
            case "fire aspect": {
                return String.format("Burns target for %d seconds (4 per level)", level * 4);
            }
            case "looting": {
                return String.format("+%d%% loot drops (33%% per level)", level * 33);
            }
            case "sweeping edge": {
                return String.format("Adds %d%%-75%% sweeping damage (25%% per level)", 25 + (level - 1) * 25);
            }
            case "impaling": {
                return String.format("+%.1f damage vs aquatic mobs (2.5 per level)", (double)level * 2.5);
            }
            case "efficiency": {
                return String.format("+%d%% mining speed (30%% per level)", level * 30);
            }
            case "fortune": {
                int fortuneChance = level * 20;
                return String.format("%d%% chance for extra drops (+20%% per level)", Math.min(fortuneChance, 100));
            }
            case "unbreaking": {
                double reduction = 100.0 - 100.0 / ((double)level + 1.0);
                return String.format("Reduces durability loss by %.1f%%", reduction);
            }
            case "power": {
                return String.format("+%d%% arrow damage (25%% per level)", level * 25);
            }
            case "punch": {
                return String.format("Adds %d blocks knockback (3 per level)", level * 3);
            }
            case "quick charge": {
                return String.format("%d%% faster reload (25%% per level)", level * 25);
            }
            case "piercing": {
                return String.format("Pierces through %d entities (1 per level)", level);
            }
            case "mending": {
                return "Repairs 2 durability per XP orb";
            }
            case "infinity": {
                return "100% chance to not consume arrows";
            }
            case "channeling": {
                return level == 1 ? "Summons lightning during storms" : "Max level is I";
            }
            case "riptide": {
                return String.format("Launches player %d blocks (scales with level)", level * 3);
            }
            case "curse of binding": 
            case "curse of vanishing": {
                return "Effect is always active (100%)";
            }
        }
        return "Active (level " + level + ")";
    }

    private static String formatRequirement(int playerLevel, ConfigData data) {
        String color = playerLevel < data.getLevel() ? "\u00a7c" : "\u00a7a";
        return String.format("%sLevel: %d%s, Xp: %.1f", color, data.getLevel(), playerLevel < data.getLevel() ? " (Current: " + playerLevel + ")" : "", data.getXp());
    }

    private static String formatToolRequirement(int playerLevel, ConfigData data) {
        String color = playerLevel < data.getLevel() ? "\u00a7c" : "\u00a7a";
        return String.format("%sLevel: %d%s", color, data.getLevel(), playerLevel < data.getLevel() ? " (Current: " + playerLevel + ")" : "");
    }

    private static String formatCombatRequirement(int playerLevel, ConfigData data) {
        String color = playerLevel < data.getLevel() ? "\u00a7c" : "\u00a7a";
        return String.format("%sLevel: %d%s", color, data.getLevel(), playerLevel < data.getLevel() ? " (Current: " + playerLevel + ")" : "");
    }

    private static void addRequirementsToTooltip(TooltipContext context, Map<String, String> requirements) {
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"\u00a76RaynnaRPG: "));
        requirements.forEach((skill, text) -> context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a77" + skill + " " + text))));
    }

    private static void addFoodTooltip(TooltipContext context, Map<String, String> foodDescription) {
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)foodDescription.get("FOOD_LINE")));
    }

    private static void addEnchantmentTooltip(TooltipContext context, Map<String, String> enchants) {
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        if (enchants.containsKey("ENCHANTMENT_LINES") && !context.isAltDown) {
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)enchants.get("ENCHANTMENT_LINES")));
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)" \u25e6\u00a7e Show details..\u00a77 [Left Alt]"));
        }
        if (context.isAltDown) {
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"\u00a7dEnchantments: "));
            enchants.forEach((name, desc) -> {
                if (!name.equals("ENCHANTMENT_LINES")) {
                    context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)(" \u25e6 " + name + ": " + desc)));
                }
            });
        }
    }

    private static void addTraitsTooltip(TooltipContext context, Map<String, String> descriptions) {
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        if (descriptions.containsKey("TRAITS_LINE") && !context.isAltDown) {
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)descriptions.get("TRAITS_LINE")));
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"   \u25e6\u00a7e Show details.. \u00a77[Left Alt]"));
        }
        if (context.isAltDown) {
            context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"\u00a76  Traits: "));
            descriptions.forEach((name, desc) -> {
                if (!name.equals("TRAITS_LINE")) {
                    context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("   \u25e6 " + name + ": " + desc)));
                }
            });
        }
    }

    private static void addPropertiesTooltip(TooltipContext context, Map<String, String> traits) {
        Item item;
        if (!context.isControlDown) {
            return;
        }
        ItemStack stack = context.stack;
        List tooltip = context.event.getToolTip();
        if (SilentGearHelper.isSilentGearLoaded() && (item = stack.getItem()) instanceof GearItem) {
            GearItem gearItem = (GearItem)item;
            boolean shift = context.isShiftDown;
            GearTooltipFlag flag = GearTooltipFlag.withModifierKeys((boolean)shift, (boolean)true, (boolean)false);
            tooltip.add(Component.literal((String)"\u00a76Properties:"));
            GearPropertiesData gearProperties = GearData.getProperties((ItemStack)stack);
            Iterable<GearProperty<?, ?>> displayProperties = ClientItemEvents.getDisplayProperties(stack, flag);
            for (GearProperty<?, ?> property : displayProperties) {
                if (property == GearProperties.ENCHANTMENT_VALUE.get()) continue;
                if (property == GearProperties.TRAITS.get()) {
                    ClientItemEvents.addTraitsTooltip(context, traits);
                    continue;
                }
                if (property == GearProperties.DURABILITY.get()) {
                    ClientItemEvents.addDurabilityTooltip(context, true);
                    continue;
                }
                GearPropertyValue value = gearProperties.get(property);
                if (value == null) continue;
                for (Component line : property.getTooltipLinesUnchecked(value, flag)) {
                    tooltip.add(Component.literal((String)"\u00a77  ").append((Component)line.copy().withStyle(ChatFormatting.WHITE)));
                }
            }
            if (!flag.isAdvanced()) {
                tooltip.add(Component.literal((String)" \u25e6\u00a7e Advanced Stats \u00a77[Left Shift]"));
            }
        }
    }

    private static Iterable<GearProperty<?, ?>> getDisplayProperties(ItemStack stack, GearTooltipFlag flag) {
        if (flag.isAdvanced() && SilentGear.isDevBuild()) {
            return SgRegistries.GEAR_PROPERTY;
        }
        return GearPropertyGroups.getSortedRelevantProperties((Set)GearHelper.getType((ItemStack)stack).relevantPropertyGroups());
    }

    private static void addPartsTooltip(TooltipContext context) {
        TextListBuilder builder = new TextListBuilder();
        PartList constructionParts = GearData.getConstruction((ItemStack)context.stack).parts();
        List sortedConstructionParts = constructionParts.toSortedList();
        for (PartInstance part : sortedConstructionParts) {
            if (!part.isValid() || !part.get().isVisible()) continue;
            int partNameColor = Color.blend((int)part.getColor(context.stack), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            MutableComponent partNameText = TextUtil.withColor((MutableComponent)part.getDisplayName().copy(), (int)partNameColor);
            builder.add((Component)partNameText.append((Component)TextUtil.misc((String)"spaceBrackets", (Object[])new Object[]{part.getType().getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY)));
            if (!(part.get() instanceof CoreGearPart)) continue;
            builder.indent();
            for (MaterialInstance material : CompoundPartItem.getMaterials((ItemStack)part.getItem())) {
                int nameColor = material.getNameColor(part.getType(), (GearType)GearTypes.ALL.get());
                builder.add((Component)TextUtil.withColor((MutableComponent)material.getDisplayNameWithModifiers(part.getType(), ItemStack.EMPTY), (int)nameColor));
            }
            builder.unindent();
        }
        context.event.getToolTip().addAll(builder.build());
    }

    private static void addDurabilityTooltip(TooltipContext context, boolean silentgear) {
        ItemStack stack = context.stack;
        if (!stack.isDamageableItem()) {
            return;
        }
        int currentDamage = stack.getDamageValue();
        int maxDurability = stack.getMaxDamage();
        if (maxDurability <= 0) {
            return;
        }
        int remainingDurability = maxDurability - currentDamage;
        double remainingPercent = 100.0 * (1.0 - (double)currentDamage / (double)maxDurability);
        ChatFormatting color = remainingPercent > 70.0 ? ChatFormatting.GREEN : (remainingPercent > 30.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        MutableComponent durabilityLine = Component.literal((String)"").append((Component)Component.literal((String)((!silentgear ? "" : "  ") + "Durability: ")).withStyle(Style.EMPTY.withColor(4620980))).append((Component)Component.literal((String)(remainingDurability + "/" + maxDurability)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)String.format("%.1f", remainingPercent)).withStyle(color)).append((Component)Component.literal((String)"%").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE));
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        context.event.getToolTip().add(index.getAndIncrement(), durabilityLine);
    }

    private static void handleDebugTooltips(TooltipContext context) {
        ServerPlayer serverPlayer;
        Player player;
        if (!(context.isCreative || (player = context.event.getEntity()) instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasPermissions(2))) {
            return;
        }
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        if (!context.isShiftDown) {
            context.event.getToolTip().add(context.event.getToolTip().size(), Component.literal((String)"\u00a7eDebug\u00a77 [Left Shift]"));
            return;
        }
        context.event.getToolTip().add(context.event.getToolTip().size(), Component.literal((String)"\u00a7eDebug"));
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a7fDescription: \u00a77" + context.stack.getItem().getDescriptionId())));
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"\u00a7fTags: "));
        context.stack.getTags().forEach(tag -> context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a77- " + String.valueOf(tag.location())))));
    }

    private static class TooltipContext {
        public final ItemTooltipEvent event;
        public final ItemStack stack;
        public final ClientSkills skills;
        public final boolean isCreative;
        public final boolean isShiftDown;
        public final boolean isAltDown;
        public final boolean isControlDown;

        public TooltipContext(ItemTooltipEvent event) {
            this.event = event;
            this.stack = event.getItemStack();
            this.skills = new ClientSkills((Player)Minecraft.getInstance().player);
            this.isCreative = Minecraft.getInstance().player.isCreative();
            this.isShiftDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) == 1;
            this.isAltDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)342) == 1;
            this.isControlDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) == 1;
        }
    }
}

