/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.client.events;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.raynna.raynnarpg.RaynnaRPG;
import net.raynna.raynnarpg.client.player.ClientSkills;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.combat.CombatConfig;
import net.raynna.raynnarpg.config.crafting.CraftingConfig;
import net.raynna.raynnarpg.config.mining.MiningConfig;
import net.raynna.raynnarpg.config.smelting.SmeltingConfig;
import net.raynna.raynnarpg.config.tools.ToolConfig;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.SilentGearHelper;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="raynnarpg", value={Dist.CLIENT})
public class ClientTooltipEvent {
    private static AtomicInteger myToolTipIndex;

    private static boolean shouldProcessTooltip(ItemTooltipEvent event) {
        return event.getEntity() == null || event.getEntity().isAlive();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemHover(ItemTooltipEvent event) {
        if (!ClientTooltipEvent.shouldProcessTooltip(event)) {
            return;
        }
        myToolTipIndex = new AtomicInteger(1);
        TooltipContext context = new TooltipContext(event);
        ItemStack stack = context.event.getItemStack();
        LinkedHashMap<String, String> requirements = new LinkedHashMap<String, String>();
        ClientTooltipEvent.checkMiningRequirements(context, requirements);
        ClientTooltipEvent.checkCraftingRequirements(context, requirements);
        ClientTooltipEvent.checkSmeltingRequirements(context, requirements);
        ClientTooltipEvent.checkToolRequirements(context, requirements);
        ClientTooltipEvent.checkArmourRequirement(context, requirements);
        ClientTooltipEvent.checkWeaponRequirements(context, requirements);
        if (!requirements.isEmpty()) {
            ClientTooltipEvent.addRequirementsToTooltip(context, requirements);
        }
        ClientTooltipEvent.handleEnchantTooltips(context);
        ClientTooltipEvent.handleTraitTooltips(context);
        ClientTooltipEvent.handleFoodEffectsTooltips(context);
        ClientTooltipEvent.handleDebugTooltips(context);
    }

    private static void removeTooltipLines(TooltipContext context, String ... matches) {
        Iterator it = context.event.getToolTip().iterator();
        block0: while (it.hasNext()) {
            Component component = (Component)it.next();
            String line = component.getString().toLowerCase();
            for (String match : matches) {
                if (!line.contains(match.toLowerCase())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private static void handleFoodEffectsTooltips(TooltipContext context) {
        ItemStack stack = context.stack;
        List tooltip = context.event.getToolTip();
        if (stack.isEmpty()) {
            return;
        }
        FoodProperties foodProps = stack.getItem().getFoodProperties(stack, null);
        if (foodProps == null) {
            return;
        }
        int index = Math.min(myToolTipIndex.getAndIncrement(), tooltip.size());
        String saturdation = String.format("%.1f", Float.valueOf(foodProps.saturation()));
        String nutrition = String.format(String.valueOf(foodProps.nutrition()), new Object[0]);
        tooltip.add(index, Component.literal((String)("\u2764" + nutrition + " \ud83c\udf57" + saturdation)));
        List effects = foodProps.effects();
        if (!effects.isEmpty()) {
            index = Math.min(myToolTipIndex.getAndIncrement(), tooltip.size());
            tooltip.add(index, Component.literal((String)"\u00a7d Effects:"));
            for (FoodProperties.PossibleEffect effectPair : effects) {
                MobEffectInstance effect = effectPair.effect();
                float probability = effectPair.probability();
                String effectName = ((MobEffect)effect.getEffect().value()).getDisplayName().getString();
                String duration = MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)20.0f).getString();
                String amplifier = ClientTooltipEvent.getAmplifierString(effect.getAmplifier());
                index = Math.min(myToolTipIndex.getAndIncrement(), tooltip.size());
                tooltip.add(index, Component.literal((String)("\u00a7f " + effectName + " " + amplifier)));
                index = Math.min(myToolTipIndex.getAndIncrement(), tooltip.size());
                tooltip.add(index, Component.literal((String)("\u00a77    Duration: " + duration + (String)(probability < 1.0f ? " (" + (int)(probability * 100.0f) + "% chance)" : ""))));
            }
        }
    }

    private static String getAmplifierString(int amplifier) {
        if (amplifier <= 0) {
            return "";
        }
        return switch (amplifier) {
            case 1 -> "II";
            case 2 -> "III";
            case 3 -> "IV";
            case 4 -> "V";
            default -> "[" + (amplifier + 1) + "]";
        };
    }

    private static void handleTraitTooltips(TooltipContext context) {
        ItemStack stack = context.stack;
        List tooltip = context.event.getToolTip();
        if (!SilentGearHelper.isSilentGearLoaded()) {
            return;
        }
        HashMap<PartType, List> partTraitMap = new HashMap<PartType, List>();
        if (stack.getItem() instanceof GearItem) {
            List gearTraits = GearData.getProperties((ItemStack)stack).getTraits();
            partTraitMap.computeIfAbsent((PartType)PartTypes.MAIN.get(), k -> gearTraits);
        }
        try {
            PartInstance part = PartInstance.from((ItemStack)stack);
            if (part != null) {
                Iterator traits = part.getTraits(PartGearKey.ofAll((PartType)part.getType()));
                partTraitMap.computeIfAbsent(part.getType(), k -> new ArrayList()).addAll(traits);
            }
        }
        catch (Exception e) {
            RaynnaRPG.LOGGER.error("Error getting part traits", (Throwable)e);
        }
        try {
            MaterialInstance material = MaterialInstance.from((ItemStack)stack);
            if (material != null) {
                for (PartType partType : material.getPartTypes()) {
                    List matTraits = (List)material.getTraits(PartGearKey.ofAll((PartType)partType));
                    partTraitMap.computeIfAbsent(partType, k -> new ArrayList()).addAll(matTraits);
                }
            }
        }
        catch (Exception e) {
            RaynnaRPG.LOGGER.error("Error getting material traits", (Throwable)e);
        }
        if (partTraitMap.isEmpty()) {
            return;
        }
        AtomicInteger index = new AtomicInteger(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
        if (context.isAltDown) {
            tooltip.add(index.get(), Component.literal((String)"\u00a76Traits:"));
            for (Map.Entry entry : partTraitMap.entrySet()) {
                PartType partType = (PartType)entry.getKey();
                for (TraitInstance trait : (List)entry.getValue()) {
                    String name = trait.getTrait().getDisplayName(trait.getLevel()).getString();
                    String desc = trait.getTrait().getDescription(trait.getLevel()).getString();
                    String part = stack.getItem() instanceof GearItem ? "" : " (" + partType.getDisplayName().getString() + ")";
                    index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
                    tooltip.add(index.get(), Component.literal((String)("\u00a7f " + name + part)));
                    index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
                    tooltip.add(index.get(), Component.literal((String)("\u00a77    " + desc)));
                }
            }
        } else {
            StringBuilder compactLine = new StringBuilder("\u00a76Traits: ");
            boolean first = true;
            for (Map.Entry entry : partTraitMap.entrySet()) {
                PartType partType = (PartType)entry.getKey();
                for (TraitInstance trait : (List)entry.getValue()) {
                    if (!first) {
                        compactLine.append("\u00a77, ");
                    }
                    first = false;
                    String name = trait.getTrait().getDisplayName(trait.getLevel()).getString();
                    String part = stack.getItem() instanceof GearItem ? "" : " (" + partType.getDisplayName().getString() + ")";
                    compactLine.append("\u00a7f").append(name).append(part);
                }
            }
            tooltip.add(index.get(), Component.literal((String)compactLine.toString()));
            index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
            tooltip.add(index.get(), Component.literal((String)"\u00a7e  Trait Details [Left Alt]"));
        }
    }

    private static void handleEnchantTooltips(TooltipContext context) {
        ItemStack stack = context.stack;
        List tooltip = context.event.getToolTip();
        if (!stack.isEnchanted()) {
            return;
        }
        ItemEnchantments enchantments = stack.getTagEnchantments();
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        HashSet<String> enchantNames = new HashSet<String>();
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            Enchantment enchant = (Enchantment)((Holder)entry.getKey()).value();
            enchantNames.add(enchant.description().getString());
        }
        Iterator it = tooltip.iterator();
        block1: while (it.hasNext()) {
            String line = ((Component)it.next()).getString();
            for (String enchantName : enchantNames) {
                if (!line.contains(enchantName)) continue;
                it.remove();
                continue block1;
            }
        }
        AtomicInteger index = new AtomicInteger(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
        if (context.isAltDown) {
            tooltip.add(index.get(), Component.literal((String)"\u00a7dEnchantments:"));
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Enchantment enchant = (Enchantment)((Holder)entry.getKey()).value();
                int level = entry.getIntValue();
                String name = enchant.description().getString();
                index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
                tooltip.add(index.get(), Component.literal((String)("\u00a7f " + name + " " + level)));
                if (!name.matches("^[a-zA-Z0-9].*")) {
                    name = name.replaceAll("^[^ ]+", "").trim();
                }
                index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
                tooltip.add(index.get(), Component.literal((String)("\u00a77    " + ClientTooltipEvent.getEnchantmentDescription(name, level))));
            }
        } else {
            StringBuilder compactLine = new StringBuilder("\u00a7dEnchantments: ");
            boolean first = true;
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Enchantment enchant = (Enchantment)((Holder)entry.getKey()).value();
                int level = entry.getIntValue();
                String name = enchant.description().getString();
                if (!first) {
                    compactLine.append(", ");
                }
                compactLine.append("\u00a7f").append(name).append(" ").append(level);
                first = false;
            }
            tooltip.add(index.get(), Component.literal((String)compactLine.toString()));
            index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
            tooltip.add(index.get(), Component.literal((String)"\u00a7e  Enchant Details [Left Alt]"));
        }
    }

    private static String getEnchantmentDescription(String enchantName, int level) {
        switch (enchantName.toLowerCase()) {
            case "aqua affinity": {
                return "Increases the rate of underwater mining speed.";
            }
            case "flame": {
                return "Arrows set targets on fire.";
            }
            case "capturing": {
                return String.format("Gives a chance of %s for any mob killed to drop their spawn egg (0.5 per level)", (double)level * 0.5);
            }
            case "breach": {
                return String.format("Negate the effectiveness of enemy armour by %d%% (15%% per level)", level * 15);
            }
            case "density": {
                return String.format("Increases the damage by %s for each block fallen (0.5 per level)", (double)level * 0.5);
            }
            case "protection": {
                return String.format("Reduces all damage by %d%% (4%% per level)", level * 4);
            }
            case "fire protection": {
                return String.format("Reduces fire damage by %d%% (8%% per level)", level * 8);
            }
            case "feather falling": {
                return String.format("Reduces fall damage by %d%% (12%% per level)", level * 12);
            }
            case "blast protection": {
                return String.format("Reduces explosion damage by %d%% (8%% per level)", level * 8);
            }
            case "projectile protection": {
                return String.format("Reduces projectile damage by %d%% (8%% per level)", level * 8);
            }
            case "frost walker": {
                return "Water walked on turns into frosted ice and prevents player from taking damage from magma blocks.";
            }
            case "thorns": {
                return String.format("%d%% chance to damage attackers (15%% per level)", level * 15);
            }
            case "depth strider": {
                return String.format("Increases underwater speed by %d%% (33%% per level)", level * 33);
            }
            case "soul speed": {
                return String.format("Increases speed on soul sand by %d%% (30%% per level)", level * 30);
            }
            case "swift sneak": {
                return String.format("Increases sneak speed by %d%% (15%% per level)", level * 15);
            }
            case "sharpness": {
                return String.format("+%.1f damage (1.25 per level)", (double)level * 1.25);
            }
            case "smite": {
                return String.format("+%.1f damage vs undead (2.5 per level)", (double)level * 2.5);
            }
            case "bane of arthropods": {
                return String.format("+%.1f damage vs arthropods (2.5 per level)", (double)level * 2.5);
            }
            case "knockback": {
                return String.format("Adds %d blocks knockback (3 per level)", level * 3);
            }
            case "fire aspect": {
                return String.format("Burns target for %d seconds (4 per level)", level * 4);
            }
            case "looting": {
                return String.format("+%d%% loot drops (33%% per level)", level * 33);
            }
            case "sweeping edge": {
                return String.format("Adds %d%% sweeping damage (25%% per level)", 25 + (level - 1) * 25);
            }
            case "impaling": {
                return String.format("+%.1f damage vs aquatic mobs (2.5 per level)", (double)level * 2.5);
            }
            case "efficiency": {
                return String.format("+%d%% mining speed (30%% per level)", level * 30);
            }
            case "fortune": {
                int fortuneChance = level * 20;
                return String.format("%d%% chance for extra drops (+20%% per level)", Math.min(fortuneChance, 100));
            }
            case "unbreaking": {
                double reduction = 100.0 - 100.0 / ((double)level + 1.0);
                return String.format("Reduces durability loss by %.1f%%", reduction);
            }
            case "power": {
                return String.format("+%d%% arrow damage (25%% per level)", level * 25);
            }
            case "punch": {
                return String.format("Adds %d blocks knockback (3 per level)", level * 3);
            }
            case "quick charge": {
                return String.format("%d%% faster reload (25%% per level)", level * 25);
            }
            case "piercing": {
                return String.format("Pierces through %d entities (1 per level)", level);
            }
            case "mending": {
                return "Repairs 2 durability per XP orb";
            }
            case "infinity": {
                return "100% chance to not consume arrows";
            }
            case "channeling": {
                return level == 1 ? "Channels a bolt of lightning on hit enemy during storms" : "Max level is I";
            }
            case "riptide": {
                return String.format("Launches player %d blocks (scales with level)", level * 3);
            }
            case "curse of binding": {
                return "Item cannot be removed from armour slots, unless the cause is death or breaking.";
            }
            case "curse of vanishing": {
                return "Item will be destroy upon death";
            }
            case "silk touch": {
                return "Mined blocks will drop as blocks instead of breaking into other items/blocks";
            }
        }
        return "Active (level " + level + ")";
    }

    private static void addRequirementsToTooltip(TooltipContext context, Map<String, String> requirements) {
        AtomicInteger index = new AtomicInteger(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
        context.event.getToolTip().add(index.get(), Component.literal((String)"\u00a76RaynnaRPG: "));
        requirements.forEach((skill, text) -> {
            index.set(Math.min(myToolTipIndex.getAndIncrement(), context.event.getToolTip().size()));
            context.event.getToolTip().add(index.get(), Component.literal((String)("\u00a77" + skill + " " + text)));
        });
    }

    private static void checkMiningRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = MiningConfig.getMiningData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientTooltipEvent.formatRequirement(level, data));
        }
    }

    private static void checkCraftingRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = CraftingConfig.getCraftingData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.CRAFTING);
            requirements.put("Crafting", ClientTooltipEvent.formatRequirement(level, data));
        }
    }

    private static void checkSmeltingRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData data = SmeltingConfig.getSmeltingData(context.stack);
        if (data != null) {
            int level = context.skills.getSkillLevel(SkillType.SMELTING);
            requirements.put("Smelting", ClientTooltipEvent.formatRequirement(level, data));
        }
    }

    private static void checkToolRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData toolData;
        String harvestTier;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isPickaxe(context.stack) && (data = ToolConfig.getSilentGearData(harvestTier = SilentGearHelper.getGearProperty(context.stack, (GearProperty)GearProperties.HARVEST_TIER.get()))) != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientTooltipEvent.formatRequirement(level, data));
        }
        if ((toolData = ToolConfig.getToolData(context.stack)) != null) {
            int level = context.skills.getSkillLevel(SkillType.MINING);
            requirements.put("Mining", ClientTooltipEvent.formatRequirement(level, toolData));
        }
    }

    private static void checkArmourRequirement(TooltipContext context, Map<String, String> requirements) {
        ConfigData armourData;
        int level;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isArmor(context.stack) && (data = CombatConfig.getData(context.stack, true)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientTooltipEvent.formatRequirement(level, data));
        }
        if ((armourData = CombatConfig.getData(context.stack, true)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientTooltipEvent.formatRequirement(level, armourData));
        }
    }

    private static void checkWeaponRequirements(TooltipContext context, Map<String, String> requirements) {
        ConfigData armourData;
        int level;
        ConfigData data;
        if (SilentGearHelper.isSilentGearLoaded() && context.stack.getItem() instanceof GearItem && SilentGearHelper.isWeapon(context.stack) && (data = CombatConfig.getData(context.stack, false)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientTooltipEvent.formatRequirement(level, data));
        }
        if ((armourData = CombatConfig.getData(context.stack, false)) != null) {
            level = context.skills.getSkillLevel(SkillType.COMBAT);
            requirements.put("Combat", ClientTooltipEvent.formatRequirement(level, armourData));
        }
    }

    private static String formatRequirement(int playerLevel, double xp, ConfigData data) {
        String color;
        String string = color = playerLevel < data.getLevel() ? "\u00a7c" : "\u00a7a";
        if (xp > 0.0) {
            return String.format("%sLevel: %d%s, Xp: %.1f", color, data.getLevel(), playerLevel < data.getLevel() ? " (Current: " + playerLevel + ")" : "", data.getXp());
        }
        return String.format("%sLevel: %d%s", color, data.getLevel(), playerLevel < data.getLevel() ? " (Current: " + playerLevel + ")" : "");
    }

    private static String formatRequirement(int playerLevel, ConfigData data) {
        return ClientTooltipEvent.formatRequirement(playerLevel, 0.0, data);
    }

    private static void handleDebugTooltips(TooltipContext context) {
        ServerPlayer serverPlayer;
        Player player;
        if (!(context.isCreative || (player = context.event.getEntity()) instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasPermissions(2))) {
            return;
        }
        AtomicInteger index = new AtomicInteger(context.event.getToolTip().size());
        if (!context.isShiftDown) {
            context.event.getToolTip().add(context.event.getToolTip().size(), Component.literal((String)"\u00a7eDebug\u00a77 [Left Shift]"));
            return;
        }
        context.event.getToolTip().add(context.event.getToolTip().size(), Component.literal((String)"\u00a7eDebug"));
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a7fDescription: \u00a77" + context.stack.getItem().getDescriptionId())));
        context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)"\u00a7fTags: "));
        context.stack.getTags().forEach(tag -> context.event.getToolTip().add(index.getAndIncrement(), Component.literal((String)("\u00a77- " + String.valueOf(tag.location())))));
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(ClientTooltipEvent.class);
    }

    private static class TooltipContext {
        public final ItemTooltipEvent event;
        public final ItemStack stack;
        public final ClientSkills skills;
        public final boolean isCreative;
        public final boolean isShiftDown;
        public final boolean isAltDown;
        public final boolean isControlDown;

        public TooltipContext(ItemTooltipEvent event) {
            this.event = event;
            this.stack = event.getItemStack();
            this.skills = new ClientSkills((Player)Minecraft.getInstance().player);
            this.isCreative = Minecraft.getInstance().player.isCreative();
            this.isShiftDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) == 1;
            this.isAltDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)342) == 1;
            this.isControlDown = GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) == 1;
        }
    }
}

