/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.client.player;

import net.minecraft.world.entity.player.Player;
import net.raynna.raynnarpg.server.player.skills.Skill;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.server.player.skills.Skills;

public class ClientSkills {
    private static final Skills skills = new Skills();
    private Player player;

    public ClientSkills(Player player) {
        this.player = player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void updateSkills(Skills newSkills) {
        for (SkillType type : SkillType.values()) {
            Skill newSkill = newSkills.getSkill(type);
            Skill existingSkill = skills.getSkill(type);
            if (existingSkill == null || newSkill == null) continue;
            skills.getSkill(type).updateSkill(newSkill.getLevel(), newSkill.getXp());
        }
    }

    public int getSkillLevel(SkillType skillType) {
        Skill skill = skills.getSkill(skillType);
        if (skill == null) {
            return 1;
        }
        return skill.getLevel();
    }

    public double getSkillExperience(SkillType skillType) {
        Skill skill = skills.getSkill(skillType);
        if (skill == null) {
            return 0.0;
        }
        return skill.getXp();
    }

    public int getLevelForXp(double xp) {
        for (int level = 1; level <= 50; ++level) {
            if (!(ClientSkills.getXpForLevel(level) > xp)) continue;
            return level - 1;
        }
        return 50;
    }

    public static double getXpForLevel(int level) {
        double totalXP = 0.0;
        for (int n = 1; n < level; ++n) {
            totalXP += Math.floor((double)n + 230.0 * Math.pow(2.0, (double)n / 6.0));
        }
        return (long)Math.floor(totalXP / 2.0);
    }

    public static Skill getSkill(SkillType skillType) {
        return skills.getSkill(skillType);
    }
}

