/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.client.ui.floating_text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class FloatingText {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final float GUI_LAYER = 5000.0f;
    private static final long DEFAULT_DURATION = 3000L;
    private static final float DEFAULT_SPEED = 1000.0f;
    private static final float SCALE_DISTANCE_FACTOR = 5.0f;
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float SCREEN_SPACE_SCALE = 0.75f;
    private static final boolean DEBUG = true;
    private final Component text;
    private final Vec3 position;
    private final long createTime;
    private final boolean screenSpace;
    private final int color;
    private final long duration;
    private final float scale;

    private FloatingText(Component text, Vec3 position, boolean screenSpace, int color, long duration, float scale) {
        this.text = text;
        this.position = position;
        this.screenSpace = screenSpace;
        this.color = color;
        this.duration = duration;
        this.scale = scale;
        this.createTime = System.currentTimeMillis();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FloatingText createOnBlock(String text, BlockPos pos) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), false, 0xFFFFFF, 3000L, 1.0f);
    }

    public static FloatingText createCentered(String text, float centerX, float centerY) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3((double)centerX, (double)centerY, 1500.0), true, 0xFFFFFF, 3000L, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FloatingText createCentered(String text) {
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        return new FloatingText((Component)Component.literal((String)text), new Vec3((double)((float)width / 2.0f), (double)((float)height / 2.0f), 1500.0), true, 0xFFFFFF, 3000L, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FloatingText createScreenSpace(String text, double x, double y) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3(x, y, 1500.0), true, 0xFFFFFF, 3000L, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FloatingText createWorldSpace(String text, double x, double y, double z) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3(x, y, z), false, 0xFFFFFF, 3000L, 1.0f);
    }

    public static FloatingText sendOnWorld(String text, double x, double y, double z) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3(x, y, z), false, 0xFFFFFF, 3000L, 1.0f);
    }

    public static FloatingText sendOnScreen(String text, double x, double y) {
        return new FloatingText((Component)Component.literal((String)text), new Vec3(x, y, 1500.0), true, 0xFFFFFF, 3000L, 0.75f);
    }

    public void render(GuiGraphics guiGraphics, Camera camera) {
        if (this.isExpired()) {
            return;
        }
        float progress = (float)(System.currentTimeMillis() - this.createTime) / (float)this.duration;
        float fade = 1.0f - (float)Math.pow(progress, 2.0);
        fade = Math.max(0.1f, Math.min(1.0f, fade));
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (this.screenSpace) {
            this.renderScreenSpace(guiGraphics, fade);
        } else {
            this.renderWorldSpace(guiGraphics, camera, fade);
        }
        poseStack.popPose();
    }

    private void renderWorldSpace(GuiGraphics guiGraphics, Camera camera, float fade) {
        float yOffset = (float)(System.currentTimeMillis() - this.createTime) / 1000.0f;
        ScreenPosition screenPos = this.calculateScreenPosition(this.position.add(0.0, (double)yOffset, 0.0), camera);
        if (screenPos == null || screenPos.isBehindCamera) {
            return;
        }
        float finalScale = (float)((double)this.scale * (5.0 / Math.max(1.0, screenPos.distance)));
        this.renderText(guiGraphics, screenPos.x, screenPos.y, finalScale, fade, 0.0f);
    }

    private void renderScreenSpace(GuiGraphics guiGraphics, float fade) {
        this.renderText(guiGraphics, (float)this.position.x, (float)this.position.y, 0.75f, fade, 5000.0f);
    }

    private void renderText(GuiGraphics guiGraphics, float x, float y, float scale, float fade, float zLevel) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, zLevel);
        poseStack.scale(scale, scale, 1.0f);
        if (this.screenSpace) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        int textWidth = FloatingText.mc.font.width((FormattedText)this.text);
        int alpha = (int)(255.0f * fade);
        guiGraphics.fill(-textWidth / 2 - 2, -2, textWidth / 2 + 2, 10, alpha / 2 << 24);
        int finalColor = alpha << 24 | this.color & 0xFFFFFF;
        guiGraphics.drawString(FloatingText.mc.font, this.text, -textWidth / 2, 0, finalColor);
        poseStack.popPose();
        RenderSystem.enableDepthTest();
    }

    private ScreenPosition calculateScreenPosition(Vec3 worldPos, Camera camera) {
        Vec3 viewPos = worldPos.subtract(camera.getPosition());
        double distance = viewPos.length();
        Vector3f look = camera.getLookVector();
        Vector3f up = camera.getUpVector();
        Vector3f right = new Vector3f((Vector3fc)look).cross((Vector3fc)up);
        float vx = (float)viewPos.dot(new Vec3((double)right.x(), (double)right.y(), (double)right.z()));
        float vy = (float)viewPos.dot(new Vec3((double)up.x(), (double)up.y(), (double)up.z()));
        float vz = (float)viewPos.dot(new Vec3((double)look.x(), (double)look.y(), (double)look.z()));
        if (vz <= 0.1f) {
            return new ScreenPosition(0.0f, 0.0f, distance, true);
        }
        float aspect = (float)mc.getWindow().getWidth() / (float)mc.getWindow().getHeight();
        float fov = (float)Math.toRadians(((Integer)FloatingText.mc.options.fov().get()).intValue());
        float tanFOV = (float)Math.tan(fov / 2.0f);
        float sx = vx / (vz * tanFOV * aspect);
        float sy = vy / (vz * tanFOV);
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        float screenX = (sx + 1.0f) / 2.0f * (float)screenWidth;
        float screenY = (1.0f - (sy + 1.0f) / 2.0f) * (float)screenHeight;
        return new ScreenPosition(screenX, screenY, distance, false);
    }

    private float calculateFade() {
        return 1.0f - (float)Math.pow((float)(System.currentTimeMillis() - this.createTime) / (float)this.duration, 2.0);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createTime >= this.duration;
    }

    private void logCreation() {
        System.out.printf("[FloatingText] Created at %s: %s (ScreenSpace: %b, WorldFloating: %b)%n", this.position.toString(), this.text.getString(), this.screenSpace);
    }

    private void logExpiration() {
        System.out.println("[FloatingText] Expired: " + this.text.getString());
    }

    public FloatingText withColor(int color) {
        return new FloatingText(this.text, this.position, this.screenSpace, color, this.duration, this.scale);
    }

    public FloatingText withDuration(long newDuration) {
        return new FloatingText(this.text, this.position, this.screenSpace, this.color, newDuration, this.scale);
    }

    public FloatingText withScale(float newScale) {
        return new FloatingText(this.text, this.position, this.screenSpace, this.color, this.duration, newScale);
    }

    private static class ScreenPosition {
        public final float x;
        public final float y;
        public final double distance;
        public final boolean isBehindCamera;

        public ScreenPosition(float x, float y, double distance, boolean isBehindCamera) {
            this.x = x;
            this.y = y;
            this.distance = distance;
            this.isBehindCamera = isBehindCamera;
        }
    }
}

