/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.client.ui.skills;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.raynna.raynnarpg.Config;
import net.raynna.raynnarpg.client.player.ClientSkills;
import net.raynna.raynnarpg.server.player.skills.Skill;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.Utils;

@OnlyIn(value=Dist.CLIENT)
public class SkillBar {
    private static final int XP_BAR_WIDTH = 100;
    private static final int XP_BAR_HEIGHT = 5;
    private static final int TEXT_Y_OFFSET = 12;
    private static final int XP_GAIN_Y_OFFSET = -8;
    private static final long XP_GAIN_DURATION_MS = 5000L;
    private static final int BASE_BAR_COLOR = -16733696;
    private static final int BACKGROUND_COLOR = -12303292;
    private final SkillType type;
    private static long XP_GAIN_TIMER = -1L;
    private XpGainMessage currentXpGainMessage;

    public SkillBar(SkillType type) {
        this.type = type;
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        Skill skill = ClientSkills.getSkill(this.type);
        if (skill == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        this.drawSkillText(guiGraphics, mc, x, y, skill);
        this.drawXpBar(guiGraphics, x, y + 12, skill);
        this.drawXpGainMessages(guiGraphics, x, y + 12 + -8);
    }

    public void addXpGain(double amount) {
        long currentTime = System.currentTimeMillis();
        if (this.currentXpGainMessage == null || currentTime - this.currentXpGainMessage.startTime >= 5000L) {
            this.currentXpGainMessage = new XpGainMessage(amount);
        } else {
            this.currentXpGainMessage.amount += amount;
            this.currentXpGainMessage.startTime = currentTime;
        }
        XP_GAIN_TIMER = 5000L;
    }

    private void drawSkillText(GuiGraphics guiGraphics, Minecraft mc, int x, int y, Skill skill) {
        guiGraphics.drawString(mc.font, (Component)Component.literal((String)(this.type.getName() + " Lv. " + skill.getLevel() + "/50")), x, y, 0xFFFFFF);
    }

    private void drawXpBar(GuiGraphics guiGraphics, int x, int y, Skill skill) {
        int currentLevel = skill.getLevel();
        double currentXp = skill.getXp();
        double currentLevelXp = ClientSkills.getXpForLevel(currentLevel);
        double nextLevelXp = ClientSkills.getXpForLevel(currentLevel + 1);
        double xpNeededForLevel = nextLevelXp - currentLevelXp;
        double progress = Math.min((currentXp - currentLevelXp) / xpNeededForLevel, 1.0);
        int barWidth = (int)(100.0 * progress);
        guiGraphics.fill(x, y, x + 100, y + 5, -12303292);
        guiGraphics.fill(x, y, x + barWidth, y + 5, -16733696);
        this.drawXpText(guiGraphics, x, y - 1, skill);
    }

    private void drawXpGainMessages(GuiGraphics guiGraphics, int x, int y) {
        if (this.currentXpGainMessage == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Font font = Minecraft.getInstance().font;
        float age = (float)(currentTime - this.currentXpGainMessage.startTime) / 5000.0f;
        if (age >= 0.9f) {
            this.currentXpGainMessage = null;
            XP_GAIN_TIMER = -1L;
            return;
        }
        float fade = 1.0f - Math.max(0.0f, (age - 0.6f) * 2.5f);
        int alpha = (int)(255.0f * fade);
        int color = alpha << 24 | 0xFFFFFF;
        String text = String.format("+%.0f XP", this.currentXpGainMessage.amount);
        int textWidth = font.width(text);
        guiGraphics.pose().pushPose();
        float scale = 0.8f;
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int scaledX = (int)((float)(x + 100 + 4) / scale);
        int scaledY = (int)((float)(y + 7) / scale);
        guiGraphics.drawString(font, (Component)Component.literal((String)text), scaledX, scaledY, color, false);
        guiGraphics.pose().popPose();
    }

    private void drawXpText(GuiGraphics guiGraphics, int x, int y, Skill skill) {
        Font font = Minecraft.getInstance().font;
        boolean isMaxLevel = skill.getLevel() == 50;
        String mode = String.valueOf(Config.Client.XP_TEXT_MODE.get());
        double currentLevelXp = ClientSkills.getXpForLevel(skill.getLevel());
        double nextLevelXp = ClientSkills.getXpForLevel(skill.getLevel() + 1);
        double currentXp = skill.getXp();
        double totalXpNeeded = nextLevelXp;
        double xpNeeded = nextLevelXp - currentLevelXp;
        double xpInLevel = skill.getXp() - currentLevelXp;
        double progress = xpInLevel / xpNeeded;
        String xpText = switch (mode) {
            case "PERCENT" -> {
                if (isMaxLevel) {
                    yield "Max Lvl";
                }
                yield Utils.formatPercentage(progress);
            }
            case "BOTH" -> {
                if (isMaxLevel) {
                    yield "Max Lvl";
                }
                yield String.format("%.0f/%.0f (%s)", currentXp, totalXpNeeded, Utils.formatPercentage(progress));
            }
            default -> isMaxLevel ? "Max Lvl" : String.format("%.0f / %.0f", currentXp, totalXpNeeded);
        };
        guiGraphics.pose().pushPose();
        float scale = 0.6f;
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int textWidth = font.width(xpText);
        int textX = (int)(((float)x + 50.0f - (float)textWidth * scale / 2.0f) / scale);
        float f = (float)y + 2.5f;
        Objects.requireNonNull(font);
        int textY = (int)(((double)(f - 9.0f * scale / 2.0f) + 1.5) / (double)scale);
        guiGraphics.drawString(font, (Component)Component.literal((String)xpText), textX, textY, 0xFFFFFF, false);
        guiGraphics.pose().popPose();
    }

    private static class XpGainMessage {
        double amount;
        long startTime;

        XpGainMessage(double amount) {
            this.amount = amount;
            this.startTime = System.currentTimeMillis();
        }
    }
}

