/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.config.combat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.combat.CombatEntry;
import net.raynna.raynnarpg.utils.SilentGearHelper;
import net.raynna.raynnarpg.utils.Utils;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.setup.gear.GearProperties;

public class CombatConfig {
    public static final Map<String, ModConfigSpec.ConfigValue<Integer>> WEAPONS = new HashMap<String, ModConfigSpec.ConfigValue<Integer>>();
    public static final Map<String, ModConfigSpec.ConfigValue<Integer>> GEARS = new HashMap<String, ModConfigSpec.ConfigValue<Integer>>();

    public static void registerMultipleConfigs(ModConfigSpec.Builder builder, String subCategoryKey, String translation, List<CombatEntry> entries) {
        builder.translation(translation).push(subCategoryKey);
        for (CombatEntry entry : entries) {
            CombatConfig.registerConfig(builder, entry.key(), entry.level(), entry.armour());
        }
        builder.pop();
    }

    public static void registerConfig(ModConfigSpec.Builder builder, String key, int level, boolean armour) {
        String itemId;
        String modId = key.contains(":") ? key.split(":")[0] : key;
        String string = itemId = key.contains(":") ? key.split(":")[1] : key;
        if (key.contains("tier")) {
            key = key.split(":")[1];
        }
        String readableType = itemId.replace("_", " ");
        String keyTranslation = Utils.capitalize(readableType) + " Level";
        ModConfigSpec.ConfigValue configValue = builder.translation(keyTranslation).comment("Configurations for level requirements for " + readableType).comment("Default: " + level).define(modId + "_" + itemId + "_level", (Object)level);
        if (armour) {
            GEARS.put(key, (ModConfigSpec.ConfigValue<Integer>)configValue);
        } else {
            WEAPONS.put(key, (ModConfigSpec.ConfigValue<Integer>)configValue);
        }
    }

    public static ConfigData getSilentGearData(String tier, boolean armour) {
        ModConfigSpec.ConfigValue<Integer> levelValue = GEARS.get(tier.toLowerCase());
        return levelValue != null ? new ConfigData((Integer)levelValue.get(), 0.0) : null;
    }

    public static ConfigData getData(ItemStack stack, boolean armour) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (!SilentGearHelper.isWeapon(stack) && !SilentGearHelper.isArmor(stack)) {
            return null;
        }
        if (SilentGearHelper.isSilentGearLoaded() && stack.getItem() instanceof GearItem) {
            String tier = SilentGearHelper.getGearProperty(stack, (GearProperty)GearProperties.HARVEST_TIER.get());
            return CombatConfig.getSilentGearData(tier, armour);
        }
        ModConfigSpec.ConfigValue<Integer> levelValue = armour ? GEARS.get(itemId) : WEAPONS.get(itemId);
        return levelValue != null ? new ConfigData((Integer)levelValue.get(), 0.0) : null;
    }
}

