/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.config.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.crafting.CraftingEntry;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.server.player.skills.Skills;
import net.raynna.raynnarpg.utils.Utils;

public class CraftingConfig {
    public static final Map<String, ModConfigSpec.ConfigValue<Integer>> CRAFTING_LEVEL = new HashMap<String, ModConfigSpec.ConfigValue<Integer>>();
    public static final Map<String, ModConfigSpec.ConfigValue<Double>> CRAFTING_XP = new HashMap<String, ModConfigSpec.ConfigValue<Double>>();
    public static final Map<String, ModConfigSpec.ConfigValue<List<String>>> CRAFTING_TAGS = new HashMap<String, ModConfigSpec.ConfigValue<List<String>>>();

    public static void registerMultipleConfigs(ModConfigSpec.Builder builder, String subCategoryKey, String translation, List<CraftingEntry> entries) {
        builder.translation(translation).push(subCategoryKey);
        for (CraftingEntry entry : entries) {
            CraftingConfig.registerConfig(builder, entry.key(), entry.level(), entry.xp(), entry.tags());
        }
        builder.pop();
    }

    public static void registerConfig(ModConfigSpec.Builder builder, String key, int level, double xp, String ... tags) {
        String modId = key.contains(":") ? key.split(":")[0] : key;
        String item = key.contains(":") ? key.split(":")[1] : key;
        String readableName = item.replace("_", " ");
        String keyTranslation = Utils.capitalize(readableName);
        if (key.contains("tier")) {
            key = key.split(":")[1];
        }
        if (xp == 0.0) {
            xp = Skills.getXpForMaterial(level, SkillType.CRAFTING);
        }
        ModConfigSpec.ConfigValue levelValue = builder.translation(keyTranslation + " Level: ").comment("Config on crafting level requirement for " + readableName + " materials").comment("Default: " + level).define(modId + "_" + item + "_level", (Object)level);
        ModConfigSpec.ConfigValue xpValue = builder.translation(keyTranslation + " Xp: ").comment("Config on crafting experience yield for " + readableName + " materials").comment("Default: " + xp).define(modId + "_" + item + "_xp", (Object)xp);
        ArrayList<String> tagList = new ArrayList<String>(List.of(tags));
        ModConfigSpec.ConfigValue tagsValue = builder.translation(keyTranslation + " Tags: ").comment("Default: " + String.valueOf(tagList)).define(modId + "_" + item + "_tags", tagList);
        CRAFTING_LEVEL.put(key, (ModConfigSpec.ConfigValue<Integer>)levelValue);
        CRAFTING_XP.put(key, (ModConfigSpec.ConfigValue<Double>)xpValue);
        CRAFTING_TAGS.put(key, (ModConfigSpec.ConfigValue<List<String>>)tagsValue);
    }

    public static ConfigData getCraftingData(ItemStack stack) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        ConfigData data = CraftingConfig.getCraftingDataByKey(itemId);
        if (data != null) {
            return data;
        }
        Optional matchingTag = stack.getTags().toList().stream().map(tag -> tag.location().toString()).flatMap(tagName -> CRAFTING_TAGS.entrySet().stream().filter(entry -> ((List)((ModConfigSpec.ConfigValue)entry.getValue()).get()).contains(tagName))).findAny();
        if (matchingTag.isPresent()) {
            Map.Entry entry = (Map.Entry)matchingTag.get();
            return CraftingConfig.getCraftingDataByKey((String)entry.getKey());
        }
        return null;
    }

    private static ConfigData getCraftingDataByKey(String key) {
        ModConfigSpec.ConfigValue<Integer> levelValue = CRAFTING_LEVEL.get(key);
        ModConfigSpec.ConfigValue<Double> xpValue = CRAFTING_XP.get(key);
        ModConfigSpec.ConfigValue<List<String>> tagsValue = CRAFTING_TAGS.get(key);
        int level = levelValue != null ? (Integer)levelValue.get() : 0;
        double xp = xpValue != null ? (Double)xpValue.get() : 0.0;
        List tagsList = tagsValue != null ? (List)tagsValue.get() : List.of();
        String tags = String.join((CharSequence)", ", tagsList);
        if (level != 0 || xp != 0.0 || !tagsList.isEmpty()) {
            return new ConfigData(level, xp, tags);
        }
        return null;
    }
}

