/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.config.mining;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.mining.MiningEntry;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.server.player.skills.Skills;
import net.raynna.raynnarpg.utils.Utils;

public class MiningConfig {
    public static final Map<String, ModConfigSpec.ConfigValue<Integer>> MINING_LEVEL = new HashMap<String, ModConfigSpec.ConfigValue<Integer>>();
    public static final Map<String, ModConfigSpec.ConfigValue<Double>> MINING_XP = new HashMap<String, ModConfigSpec.ConfigValue<Double>>();
    public static final Map<String, ModConfigSpec.ConfigValue<List<String>>> MINING_TAGS = new HashMap<String, ModConfigSpec.ConfigValue<List<String>>>();

    public static void registerMultipleConfigs(ModConfigSpec.Builder builder, String subCategoryKey, String translation, List<MiningEntry> entries) {
        builder.translation(translation).push(subCategoryKey);
        for (MiningEntry entry : entries) {
            MiningConfig.registerConfig(builder, entry.key(), entry.level(), entry.xp(), entry.tags());
        }
        builder.pop();
    }

    public static void registerConfig(ModConfigSpec.Builder builder, String key, int level, double xp, String ... tags) {
        String modId = key.contains(":") ? key.split(":")[0] : key;
        String item = key.contains(":") ? key.split(":")[1] : key;
        String readableName = item.replace("_", " ");
        String keyTranslation = Utils.capitalize(readableName);
        if (xp == 0.0) {
            xp = Skills.getXpForMaterial(level, SkillType.MINING);
        }
        ModConfigSpec.ConfigValue levelValue = builder.translation(keyTranslation + " Level: ").comment("Config on mining level requirement for " + readableName + ".").comment("Default: " + level).define(modId + "_" + item + "_level", (Object)level);
        ModConfigSpec.ConfigValue xpValue = builder.translation(keyTranslation + " Xp: ").comment("Config on mining experience yield for " + readableName + ".").comment("Default: " + xp).define(modId + "_" + item + "_xp", (Object)xp);
        ArrayList<String> tagList = new ArrayList<String>(List.of(tags));
        ModConfigSpec.ConfigValue tagsValue = builder.translation(keyTranslation + " Tags: ").comment("Default: " + String.valueOf(tagList)).define(modId + "_" + item + "_tags", tagList);
        MINING_LEVEL.put(key, (ModConfigSpec.ConfigValue<Integer>)levelValue);
        MINING_XP.put(key, (ModConfigSpec.ConfigValue<Double>)xpValue);
        MINING_TAGS.put(key, (ModConfigSpec.ConfigValue<List<String>>)tagsValue);
    }

    public static ConfigData getMiningData(ItemStack stack) {
        String blockId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        ConfigData data = MiningConfig.getMiningDataByKey(blockId);
        if (data != null) {
            return data;
        }
        Optional matchingTag = stack.getTags().toList().stream().map(tag -> tag.location().toString()).flatMap(tagName -> MINING_TAGS.entrySet().stream().filter(entry -> ((List)((ModConfigSpec.ConfigValue)entry.getValue()).get()).contains(tagName))).findAny();
        if (matchingTag.isPresent()) {
            Map.Entry entry = (Map.Entry)matchingTag.get();
            return MiningConfig.getMiningDataByKey((String)entry.getKey());
        }
        return null;
    }

    public static ConfigData getMiningData(BlockState state) {
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        ConfigData data = MiningConfig.getMiningDataByKey(blockId);
        if (data != null) {
            return data;
        }
        Optional matchingTag = state.getTags().toList().stream().map(tag -> tag.location().toString()).flatMap(tagName -> MINING_TAGS.entrySet().stream().filter(entry -> ((List)((ModConfigSpec.ConfigValue)entry.getValue()).get()).contains(tagName))).findAny();
        if (matchingTag.isPresent()) {
            Map.Entry entry = (Map.Entry)matchingTag.get();
            return MiningConfig.getMiningDataByKey((String)entry.getKey());
        }
        return null;
    }

    private static ConfigData getMiningDataByKey(String key) {
        ModConfigSpec.ConfigValue<Integer> levelValue = MINING_LEVEL.get(key);
        ModConfigSpec.ConfigValue<Double> xpValue = MINING_XP.get(key);
        ModConfigSpec.ConfigValue<List<String>> tagsValue = MINING_TAGS.get(key);
        int level = levelValue != null ? (Integer)levelValue.get() : 0;
        double xp = xpValue != null ? (Double)xpValue.get() : 0.0;
        List tagsList = tagsValue != null ? (List)tagsValue.get() : List.of();
        String tags = String.join((CharSequence)", ", tagsList);
        if (level != 0 || xp != 0.0 || !tagsList.isEmpty()) {
            return new ConfigData(level, xp, tags);
        }
        return null;
    }
}

