/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.config.smelting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.smelting.SmeltingEntry;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.server.player.skills.Skills;
import net.raynna.raynnarpg.utils.Utils;

public class SmeltingConfig {
    public static final Map<String, ModConfigSpec.ConfigValue<Integer>> SMELTING_LEVEL = new HashMap<String, ModConfigSpec.ConfigValue<Integer>>();
    public static final Map<String, ModConfigSpec.ConfigValue<Double>> SMELTING_XP = new HashMap<String, ModConfigSpec.ConfigValue<Double>>();
    public static final Map<String, ModConfigSpec.ConfigValue<String>> SMELTING_RAW_MATERIAL = new HashMap<String, ModConfigSpec.ConfigValue<String>>();

    public static void registerMultipleConfigs(ModConfigSpec.Builder builder, String subCategoryKey, String translation, List<SmeltingEntry> entries) {
        builder.translation(translation).push(subCategoryKey);
        for (SmeltingEntry entry : entries) {
            SmeltingConfig.registerConfig(builder, entry.key(), entry.level(), entry.xp(), entry.rawVariant());
        }
        builder.pop();
    }

    public static void registerConfig(ModConfigSpec.Builder builder, String key, int level, double xp, String rawVariant) {
        String modId = key.contains(":") ? key.split(":")[0] : key;
        String item = key.contains(":") ? key.split(":")[1] : key;
        String name = Utils.capitalize(item).replace("_", " ");
        if (key.contains("tier")) {
            key = key.split(":")[1];
        }
        if (xp == 0.0) {
            xp = Skills.getXpForMaterial(level, SkillType.SMELTING);
        }
        ModConfigSpec.ConfigValue levelValue = builder.translation(name + " Level: ").comment("Config on smelting level requirement for " + name + ".").comment("Default: " + level).define(modId + "_" + item + "_level", (Object)level);
        ModConfigSpec.ConfigValue xpValue = builder.translation(name + " Xp: ").comment("Config on smelting experience yield for " + name + ".").comment("Default: " + xp).define(modId + "_" + item + "_xp", (Object)xp);
        ModConfigSpec.ConfigValue rawValue = builder.translation(name + " Raw Variant: ").comment("Default: " + rawVariant).define(modId + "_" + item + "_raw", (Object)rawVariant);
        SMELTING_LEVEL.put(key, (ModConfigSpec.ConfigValue<Integer>)levelValue);
        SMELTING_XP.put(key, (ModConfigSpec.ConfigValue<Double>)xpValue);
        SMELTING_RAW_MATERIAL.put(key, (ModConfigSpec.ConfigValue<String>)rawValue);
    }

    public static ConfigData getSmeltingData(ItemStack stack) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        ConfigData data = SmeltingConfig.getSmeltingDataByKey(itemId);
        if (data == null) {
            data = SmeltingConfig.findDataByRawVariant(itemId);
        }
        return data;
    }

    private static ConfigData getSmeltingDataByKey(String key) {
        String raw;
        ModConfigSpec.ConfigValue<Integer> levelValue = SMELTING_LEVEL.get(key);
        ModConfigSpec.ConfigValue<Double> xpValue = SMELTING_XP.get(key);
        ModConfigSpec.ConfigValue<String> rawValue = SMELTING_RAW_MATERIAL.get(key);
        int level = levelValue != null ? (Integer)levelValue.get() : 0;
        double xp = xpValue != null ? (Double)xpValue.get() : 0.0;
        String string = raw = rawValue != null ? (String)rawValue.get() : "";
        if (level != 0 || xp != 0.0 || !raw.isEmpty()) {
            return new ConfigData(level, xp, "none", raw);
        }
        return null;
    }

    private static ConfigData findDataByRawVariant(String rawItemId) {
        for (Map.Entry<String, ModConfigSpec.ConfigValue<String>> entry : SMELTING_RAW_MATERIAL.entrySet()) {
            if (!rawItemId.equals(entry.getValue().get())) continue;
            return new ConfigData((Integer)SMELTING_LEVEL.get(entry.getKey()).get(), (Double)SMELTING_XP.get(entry.getKey()).get(), "none", rawItemId);
        }
        return null;
    }
}

