/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.network.packets.xpdrop;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.PacketFlow;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.raynna.raynnarpg.RaynnaRPG;
import net.raynna.raynnarpg.client.ui.SkillOverlay;
import net.raynna.raynnarpg.client.ui.floating_text.FloatingText;
import net.raynna.raynnarpg.network.packets.xpdrop.FloatingTextPacket;

public class FloatingTextHandler
implements IPayloadHandler<FloatingTextPacket> {
    @OnlyIn(value=Dist.CLIENT)
    public void handle(FloatingTextPacket packet, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            FloatingTextHandler.handleClient(packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(FloatingTextPacket packet) {
        Minecraft.getInstance().execute(() -> {
            FloatingText floatingText;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (packet.centered()) {
                int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                floatingText = FloatingText.createCentered(packet.message(), (float)width / 2.0f, (float)height / 2.0f);
            } else {
                floatingText = packet.screenSpace() ? FloatingText.createScreenSpace(packet.message(), packet.position().x, packet.position().y) : FloatingText.createWorldSpace(packet.message(), packet.position().x, packet.position().y, packet.position().z);
            }
            RaynnaRPG.getOverlayManager().addText(floatingText);
            if (packet.message().toLowerCase().contains("+") && packet.message().toLowerCase().contains("xp")) {
                String numericPart = packet.message().replaceAll("[^0-9.]", "");
                double xp = Double.parseDouble(numericPart);
                SkillOverlay.updateXpGain(packet.skillType(), xp);
            }
        });
    }
}

