/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.raynna.raynnarpg.RaynnaRPG;

public class ReversibleCraftingRegistry {
    private static final Set<Item> reversibleItems = new HashSet<Item>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path SAVE_PATH = Path.of("config", "reversible_recipes.json");

    public static void init(ServerStartedEvent event) {
        if (Files.exists(SAVE_PATH, new LinkOption[0])) {
            ReversibleCraftingRegistry.loadFromJson();
        } else {
            ReversibleCraftingRegistry.detectAndSave(event.getServer().getRecipeManager());
        }
    }

    private static void detectAndSave(RecipeManager recipeManager) {
        ReversibleCraftingRegistry.detectReversibleRecipes(recipeManager);
        ReversibleCraftingRegistry.saveToJson();
    }

    private static void detectReversibleRecipes(RecipeManager recipeManager) {
        HashMap forwardMap = new HashMap();
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof CraftingRecipe)) continue;
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            Item output = craftingRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem();
            for (Ingredient ingredient : craftingRecipe.getIngredients()) {
                for (ItemStack match : ingredient.getItems()) {
                    forwardMap.computeIfAbsent(match.getItem(), k -> new HashSet()).add(output);
                }
            }
        }
        for (Map.Entry entry : forwardMap.entrySet()) {
            Item input = (Item)entry.getKey();
            for (Item result : (Set)entry.getValue()) {
                if (!forwardMap.getOrDefault(result, Collections.emptySet()).contains(input)) continue;
                reversibleItems.add(input);
                reversibleItems.add(result);
            }
        }
    }

    private static void saveToJson() {
        try {
            Files.createDirectories(SAVE_PATH.getParent(), new FileAttribute[0]);
            List<String> itemIds = reversibleItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).sorted().toList();
            Map<String, List<String>> data = Map.of("reversible_items", itemIds);
            try (BufferedWriter writer = Files.newBufferedWriter(SAVE_PATH, new OpenOption[0]);){
                GSON.toJson(data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            RaynnaRPG.LOGGER.error("Failed to save reversible crafting data", (Throwable)e);
        }
    }

    private static void loadFromJson() {
        try (BufferedReader reader = Files.newBufferedReader(SAVE_PATH);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray array = json.getAsJsonArray("reversible_items");
            for (JsonElement element : array) {
                ResourceLocation id = ResourceLocation.parse((String)element.getAsString());
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                reversibleItems.add(item);
            }
        }
        catch (JsonParseException | IOException e) {
            RaynnaRPG.LOGGER.error("Failed to load reversible crafting data", e);
        }
    }

    public static boolean isReversible(Item item) {
        return reversibleItems.contains(item);
    }
}

