/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.raynna.raynnarpg.server.player.PlayerProgress;
import net.raynna.raynnarpg.server.player.playerdata.PlayerDataProvider;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.Colour;
import net.raynna.raynnarpg.utils.MessageSender;
import net.raynna.raynnarpg.utils.Utils;

public class LevelsCommad {
    private LevelsCommad() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"levels").executes(LevelsCommad::run));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerProgress progress = PlayerDataProvider.getPlayerProgress(player);
        MessageSender.send(player, "[Raynna's RPG] Your current skills: ", Colour.Colours.RED);
        for (SkillType type : SkillType.values()) {
            MessageSender.send(player, type.getName() + " - Level: " + progress.getSkills().getSkill(type).getLevel() + ", Xp: " + Utils.formatNumber(progress.getSkills().getSkill(type).getXp()), Colour.Colours.YELLOW);
        }
        return 1;
    }
}

