/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.events;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.raynna.raynnarpg.config.ConfigData;
import net.raynna.raynnarpg.config.mining.MiningConfig;
import net.raynna.raynnarpg.network.packets.message.MessagePacketSender;
import net.raynna.raynnarpg.network.packets.xpdrop.FloatingTextSender;
import net.raynna.raynnarpg.server.player.PlayerProgress;
import net.raynna.raynnarpg.server.player.playerdata.PlayerDataProvider;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.Utils;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TraitHelper;

public class ServerBlockEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerProgress progress = PlayerDataProvider.getPlayerProgress(player2);
        if (progress == null) {
            return;
        }
        BlockState blockState = event.getState();
        ConfigData miningData = MiningConfig.getMiningData(blockState);
        if (miningData == null) {
            return;
        }
        ServerBlockEvents.handleMiningEvent(player2, progress, event, blockState, miningData);
    }

    private static void handleMiningEvent(ServerPlayer player, PlayerProgress progress, BlockEvent.BreakEvent event, BlockState blockState, ConfigData miningData) {
        if (!ServerBlockEvents.checkMiningLevel(player, progress, event, blockState, miningData)) {
            return;
        }
        if (ServerBlockEvents.hasSilkTouch(player.getMainHandItem())) {
            MessagePacketSender.send(player, "No XP gained because you used Silk Touch.");
            return;
        }
        ServerBlockEvents.grantMiningExperience(player, progress, miningData, event.getPos());
    }

    private static boolean checkMiningLevel(ServerPlayer player, PlayerProgress progress, BlockEvent.BreakEvent event, BlockState blockState, ConfigData miningData) {
        int requiredLevel;
        int miningLevel = progress.getSkills().getSkill(SkillType.MINING).getLevel();
        if (miningLevel < (requiredLevel = miningData.getLevel())) {
            event.setCanceled(true);
            String blockName = ((Component)blockState.getBlock().getName().toFlatList().getFirst()).getString();
            MessagePacketSender.send(player, "You need a mining level of " + requiredLevel + " in order to mine " + blockName + ".");
            return false;
        }
        return true;
    }

    private static boolean hasSilkTouch(ItemStack tool) {
        ItemEnchantments enchantments = (ItemEnchantments)tool.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                if (!((Holder)entry.getKey()).is(Enchantments.SILK_TOUCH)) continue;
                return true;
            }
        }
        return TraitHelper.hasTrait((ItemStack)tool, (DataResource)Const.Traits.SILKY);
    }

    private static void grantMiningExperience(ServerPlayer player, PlayerProgress progress, ConfigData miningData, BlockPos pos) {
        int levelReq;
        double xp = miningData.getXp();
        int miningLevel = progress.getSkills().getSkill(SkillType.MINING).getLevel();
        if (Utils.isXpCapped(miningLevel, levelReq = miningData.getLevel())) {
            FloatingTextSender.sendOnBlock(player, "\u00a7cXp Capped", pos, SkillType.MINING);
            return;
        }
        progress.getSkills().addXp(SkillType.MINING, xp);
        FloatingTextSender.sendOnBlock(player, "+" + xp + "xp", pos, SkillType.MINING);
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(ServerBlockEvents.class);
    }
}

