/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.player;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.raynna.raynnarpg.network.packets.skills.SkillsPacketSender;
import net.raynna.raynnarpg.server.player.progress.Progress;
import net.raynna.raynnarpg.server.player.progress.ProgressKey;
import net.raynna.raynnarpg.server.player.skills.Skill;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.server.player.skills.Skills;
import net.raynna.raynnarpg.utils.Colour;
import net.raynna.raynnarpg.utils.MessageSender;
import net.raynna.raynnarpg.utils.StarterItems;
import net.raynna.raynnarpg.utils.Utils;
import org.slf4j.Logger;

public class PlayerProgress {
    private static final Logger LOGGER = LogUtils.getLogger();
    private UUID playerUUID;
    private Skills skills;
    private Progress progress;

    public PlayerProgress(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.skills = null;
        this.progress = null;
    }

    public void init(ServerPlayer player) {
        if (this.playerUUID == null) {
            this.playerUUID = player.getUUID();
        }
        if (this.skills == null) {
            this.skills = new Skills();
        }
        this.skills.setPlayer(player);
        for (SkillType skill : SkillType.values()) {
            if (this.skills.getSkill(skill).getLevel() >= 1) continue;
            this.skills.getSkill(skill).setLevel(1);
            MessageSender.send(player, "\u00a7cYour " + skill.getName() + " level has been set to lvl 1, due to being 0.");
        }
        if (this.progress == null) {
            this.progress = new Progress();
        }
        SkillsPacketSender.send(player, this.skills);
        if (this.progress.isActive(ProgressKey.FIRST_TIME_LOGGED_IN)) {
            this.progress.toggle(ProgressKey.FIRST_TIME_LOGGED_IN);
            if (ModList.get().isLoaded("silentgear")) {
                StarterItems.giveItems(player);
            }
            MessageSender.send(player, "[Raynna's RPG] Welcome to the server " + ((Component)player.getName().toFlatList().getFirst()).getString() + "!", Colour.Colours.GOLD);
        } else {
            MessageSender.send(player, "[Raynna's RPG] Welcome back " + ((Component)player.getName().toFlatList().getFirst()).getString() + "!", Colour.Colours.GOLD);
        }
        MessageSender.send(player, "[Raynna's RPG] Your current skills: ", Colour.Colours.RED);
        for (SkillType type : SkillType.values()) {
            MessageSender.send(player, type.getName() + " - Level: " + this.skills.getSkill(type).getLevel() + ", Xp: " + Utils.formatNumber(this.skills.getSkill(type).getXp()), Colour.Colours.YELLOW);
        }
        System.out.println("[" + player.getName().getString() + "] Loaded Skills: " + this.skills.toNBT().toString());
        System.out.println("[" + player.getName().getString() + "] Loaded Progress: " + this.progress.toNBT().toString());
    }

    public Skills getSkills() {
        return this.skills;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public PlayerProgress get(ServerPlayer player) {
        return this;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("playerUUID", this.playerUUID.toString());
        if (this.skills != null) {
            tag.put("skills", (Tag)this.skills.toNBT());
        }
        if (this.progress != null) {
            tag.put("progress", (Tag)this.progress.toNBT());
        }
        return tag;
    }

    public static PlayerProgress fromNBT(CompoundTag tag) {
        UUID playerUUID = UUID.fromString(tag.getString("playerUUID"));
        PlayerProgress playerProgress = new PlayerProgress(playerUUID);
        if (tag.contains("skills")) {
            playerProgress.skills = Skills.fromNBT(tag.getCompound("skills"));
            for (SkillType type : SkillType.values()) {
                if (playerProgress.skills.getSkill(type) != null) continue;
                playerProgress.skills.getSkills().put(type, new Skill(type));
                System.out.println("[Server] Added missing SkillType: " + type.name() + " with default values.");
            }
        }
        if (tag.contains("progress")) {
            playerProgress.progress = Progress.fromNBT(tag.getCompound("progress"));
        }
        return playerProgress;
    }
}

