/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.player.playerdata;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.raynna.raynnarpg.server.player.PlayerProgress;
import net.raynna.raynnarpg.server.player.playerdata.PlayerDataProvider;

public class PlayerDataStorage
extends SavedData {
    private final Map<UUID, PlayerProgress> playerProgress = new HashMap<UUID, PlayerProgress>();

    public static PlayerDataStorage create() {
        return new PlayerDataStorage();
    }

    public static PlayerDataStorage load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        PlayerDataStorage data = PlayerDataStorage.create();
        CompoundTag playersTag = tag.getCompound("players");
        for (String uuidStr : playersTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag playerTag = playersTag.getCompound(uuidStr);
                if (!playerTag.contains("playerUUID") || uuid == null || playerTag.getString("playerUUID").isEmpty()) {
                    System.err.println("Invalid or missing playerUUID for UUID: " + uuidStr + ". Skipping...");
                    continue;
                }
                System.out.println("Loading playerUUID: " + uuidStr);
                PlayerProgress progress = PlayerProgress.fromNBT(playerTag);
                data.playerProgress.put(uuid, progress);
            }
            catch (Exception e) {
                System.err.println("Failed to load data for player UUID: " + uuidStr + ". Skipping entry.");
                e.printStackTrace();
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerProgress.entrySet()) {
            playersTag.put(entry.getKey().toString(), (Tag)entry.getValue().toNBT());
        }
        tag.put("players", (Tag)playersTag);
        return tag;
    }

    public PlayerProgress getStats(UUID playerUUID, ServerLevel serverLevel) {
        return this.playerProgress.computeIfAbsent(playerUUID, uuid -> {
            PlayerDataStorage storage = PlayerDataProvider.getData(serverLevel);
            CompoundTag tag = storage.getPlayerDataTag(playerUUID);
            if (!tag.contains("playerUUID") || tag.getString("playerUUID").isEmpty()) {
                tag.putString("playerUUID", playerUUID.toString());
                System.out.println("Added missing playerUUID to CompoundTag for UUID: " + String.valueOf(playerUUID));
            }
            PlayerProgress progress = PlayerProgress.fromNBT(tag);
            this.markDirty();
            return progress;
        });
    }

    public static void savePlayer(ServerPlayer player) {
        PlayerProgress progress = PlayerDataProvider.getPlayerProgress(player);
        progress.toNBT();
        PlayerDataProvider.getData(player.serverLevel()).markDirty();
        if (progress.getSkills() != null) {
            System.out.println("[" + player.getName().getString() + "] Saved Skills: " + progress.getSkills().toNBT().toString());
        }
        if (progress.getProgress() != null) {
            System.out.println("[" + player.getName().getString() + "] Saved Progress: " + progress.getProgress().toNBT().toString());
        }
    }

    public CompoundTag getPlayerDataTag(UUID playerUUID) {
        PlayerProgress progress = this.playerProgress.get(playerUUID);
        if (progress != null) {
            return progress.toNBT();
        }
        return new CompoundTag();
    }

    public void markDirty() {
        this.setDirty();
    }
}

