/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.player.progress;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.nbt.CompoundTag;

public class ProgressEntry<T> {
    private final Class<T> type;
    private Object value;

    public ProgressEntry(Class<T> type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return this.value.toString();
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        Object object = this.value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Double.class, String.class, Boolean.class}, (Object)object, n)) {
            case 0: {
                Integer intValue = (Integer)object;
                tag.putInt("value", intValue.intValue());
                break;
            }
            case 1: {
                Double doubleValue = (Double)object;
                tag.putDouble("value", doubleValue.doubleValue());
                break;
            }
            case 2: {
                String stringValue = (String)object;
                tag.putString("value", stringValue);
                break;
            }
            case 3: {
                Boolean booleanValue = (Boolean)object;
                tag.putByte("value", (byte)(booleanValue != false ? 1 : 0));
                break;
            }
            default: {
                assert (this.value != null);
                throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(this.value.getClass()));
            }
        }
        return tag;
    }

    public static <T> ProgressEntry<T> fromNBT(CompoundTag tag) {
        T value = ProgressEntry.extractValue(tag);
        assert (value != null);
        Class<?> valueType = value.getClass();
        return new ProgressEntry(valueType, value);
    }

    private static <T> T extractValue(CompoundTag tag) {
        if (!tag.contains("value")) {
            return null;
        }
        if (tag.contains("value", 3)) {
            return (T)Integer.valueOf(tag.getInt("value"));
        }
        if (tag.contains("value", 6)) {
            return (T)Double.valueOf(tag.getDouble("value"));
        }
        if (tag.contains("value", 8)) {
            return (T)tag.getString("value");
        }
        if (tag.contains("value", 1)) {
            return (T)Boolean.valueOf(tag.getByte("value") != 0);
        }
        throw new IllegalArgumentException("Unsupported value type in tag");
    }
}

