/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.server.player.skills;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.raynna.raynnarpg.network.packets.skills.SkillsPacketSender;
import net.raynna.raynnarpg.network.packets.toasts.CustomToastPacketSender;
import net.raynna.raynnarpg.server.player.playerdata.PlayerDataStorage;
import net.raynna.raynnarpg.server.player.skills.Skill;
import net.raynna.raynnarpg.server.player.skills.SkillType;
import net.raynna.raynnarpg.utils.Colour;
import net.raynna.raynnarpg.utils.MessageSender;

public class Skills {
    public static final int MAX_LEVEL = 50;
    private static final double MAX_XP = 303000.0;
    private final Map<SkillType, Skill> skills = new EnumMap<SkillType, Skill>(SkillType.class);
    private ServerPlayer player;

    public Skills() {
        for (SkillType type : SkillType.values()) {
            this.skills.put(type, new Skill(type));
        }
    }

    public Map<SkillType, Skill> getSkills() {
        return this.skills;
    }

    public void setPlayer(ServerPlayer player) {
        this.player = player;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public void addXp(SkillType type, double xp) {
        Skill skill = this.getSkill(type);
        if (skill != null) {
            if (skill.getXp() >= 303000.0) {
                skill.setXp(303000.0);
                return;
            }
            int oldLevel = skill.getLevel();
            if (skill.getXp() + xp >= 303000.0) {
                skill.setXp(303000.0);
            }
            skill.setPreviousXp(skill.getXp());
            skill.addXp(xp);
            skill.setXp((double)Math.round(skill.getXp() * 100.0) / 100.0);
            int newLevel = this.getLevelForXp(skill.getXp());
            if (newLevel > oldLevel) {
                skill.setPreviousLevel(oldLevel);
                skill.setLevel(newLevel);
                int levels = newLevel - oldLevel;
                this.onLevelUp(skill, levels);
            }
            SkillsPacketSender.send(this.player, this);
        }
    }

    public int getLevelForXp(double xp) {
        for (int level = 1; level <= 50; ++level) {
            if (!(Skills.getXpForLevel(level) > xp)) continue;
            return level - 1;
        }
        return 50;
    }

    public static double getXpForLevel(int level) {
        double totalXP = 0.0;
        for (int n = 1; n < level; ++n) {
            totalXP += Math.floor((double)n + 230.0 * Math.pow(2.0, (double)n / 6.0));
        }
        return (long)Math.floor(totalXP / 2.0);
    }

    public static double getXpForMaterial(int level, SkillType type) {
        double baseXp = switch (type) {
            case SkillType.MINING, SkillType.CRAFTING -> 3.0;
            case SkillType.SMELTING -> 4.0;
            default -> 1.0;
        };
        double xp = baseXp * (1.0 + 0.45 * (double)(level - 1) + 0.0135 * Math.pow(level - 1, 2.0));
        return (double)Math.round(xp * 100.0) / 100.0;
    }

    public Skill getSkill(SkillType type) {
        return this.skills.get((Object)type);
    }

    public boolean isMaxLevel(SkillType type) {
        Skill skill = this.getSkill(type);
        return skill != null && skill.getLevel() == 50;
    }

    private void onLevelUp(Skill skill, int level) {
        MinecraftServer server;
        String skillName = skill.getType().getName();
        int currentLevel = skill.getLevel();
        String playerName = this.player.getName().getString();
        if (level > 1) {
            MessageSender.send(this.player, "Congratulations! You leveled up " + level + " " + skillName + " levels. You are now level " + currentLevel + "!", Colour.Colours.GREEN);
        } else {
            MessageSender.send(this.player, "Congratulations! You leveled up a " + skillName + " level. You are now level " + currentLevel + "!", Colour.Colours.GREEN);
        }
        this.player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        CustomToastPacketSender.send(this.player, "Level up!", "You have reached level " + currentLevel + " in " + skillName + "!");
        boolean reachedMax = this.isMaxLevel(skill.getType());
        if (reachedMax) {
            MessageSender.send(this.player, "You've achieved the highest level possible in " + skillName + "!", Colour.Colours.GOLD);
        }
        if ((server = this.player.getServer()) == null) {
            return;
        }
        String levelUpMessage = level > 1 ? playerName + " has leveled up " + level + " " + skillName + " levels. " + playerName + " is now level " + currentLevel + "!" : playerName + " has leveled up a " + skillName + " level. " + playerName + " is now level " + currentLevel + "!";
        String maxedMessage = playerName + " achieved the highest level possible in " + skillName + "!";
        MessageSender.sendAllButSelf(this.player, levelUpMessage, Colour.Colours.YELLOW);
        if (reachedMax) {
            MessageSender.sendAllButSelf(this.player, maxedMessage, Colour.Colours.GOLD);
        }
        if (this.player != null) {
            PlayerDataStorage.savePlayer(this.player);
        }
    }

    public void resetSkills() {
        for (Skill skill : this.skills.values()) {
            skill.setLevel(1);
            skill.setXp(0.0);
        }
        SkillsPacketSender.send(this.player, this);
        this.player.sendSystemMessage((Component)Component.literal((String)"You have reset all your skills."));
    }

    public CompoundTag toNBT() {
        CompoundTag skillsTag = new CompoundTag();
        for (Map.Entry<SkillType, Skill> entry : this.skills.entrySet()) {
            skillsTag.put(entry.getKey().name(), (Tag)this.serializeSkill(entry.getValue()));
        }
        return skillsTag;
    }

    public static Skills fromNBT(CompoundTag tag) {
        Skills skills = new Skills();
        for (String skillName : tag.getAllKeys()) {
            try {
                SkillType type = SkillType.valueOf(skillName);
                skills.skills.put(type, Skills.deserializeSkill(type, tag.getCompound(skillName)));
            }
            catch (IllegalArgumentException e) {
                System.out.println("Warning: SkillType " + skillName + " does not exist and will be removed.");
            }
        }
        for (SkillType type : SkillType.values()) {
            if (skills.skills.containsKey((Object)type)) continue;
            skills.skills.put(type, new Skill(type));
        }
        return skills;
    }

    private CompoundTag serializeSkill(Skill skill) {
        CompoundTag skillTag = new CompoundTag();
        skillTag.putInt("level", skill.getLevel());
        skillTag.putDouble("xp", skill.getXp());
        return skillTag;
    }

    private static Skill deserializeSkill(SkillType type, CompoundTag skillTag) {
        Skill skill = new Skill(type);
        skill.setLevel(skillTag.getInt("level"));
        skill.setXp(skillTag.getDouble("xp"));
        return skill;
    }
}

