/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;

public class CooldownManager {
    private static final Map<String, Map<Player, Long>> cooldownMap = new HashMap<String, Map<Player, Long>>();
    private static final Map<String, Long> defaultCooldowns = new HashMap<String, Long>();

    public static boolean checkCooldown(Player player, String cooldownKey, long cooldownMs) {
        long currentTime = System.currentTimeMillis();
        Map entityCooldowns = cooldownMap.computeIfAbsent(cooldownKey, k -> new HashMap());
        Long lastTime = (Long)entityCooldowns.get(player);
        if (lastTime == null || currentTime - lastTime >= cooldownMs) {
            entityCooldowns.put(player, currentTime);
            return true;
        }
        return false;
    }

    public static long getRemainingCooldown(Player player, String cooldownKey) {
        Map<Player, Long> entityCooldowns = cooldownMap.get(cooldownKey);
        if (entityCooldowns == null) {
            return 0L;
        }
        Long lastTime = entityCooldowns.get(player);
        if (lastTime == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - lastTime;
        long cooldown = CooldownManager.getCooldownDuration(cooldownKey);
        return Math.max(0L, cooldown - elapsed);
    }

    public static void resetCooldown(Player player, String cooldownKey) {
        Map<Player, Long> entityCooldowns = cooldownMap.get(cooldownKey);
        if (entityCooldowns != null) {
            entityCooldowns.remove(player);
        }
    }

    public static void clearCooldowns(String cooldownKey) {
        cooldownMap.remove(cooldownKey);
    }

    public static void clearAllCooldowns() {
        cooldownMap.clear();
    }

    public static void setDefaultCooldown(String cooldownKey, long durationMs) {
        defaultCooldowns.put(cooldownKey, durationMs);
    }

    public static long getCooldownDuration(String cooldownKey) {
        return defaultCooldowns.getOrDefault(cooldownKey, 0L);
    }
}

