/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.raynna.raynnarpg.network.packets.xpdrop.FloatingTextSender;
import net.raynna.raynnarpg.server.player.skills.SkillType;

public class CraftingTracker {
    private static final Map<ServerPlayer, CraftingTracker> craftingData = new HashMap<ServerPlayer, CraftingTracker>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private String itemName = "";
    private int craftedAmount = 0;
    private double totalExperience = 0.0;
    private long lastEventTime = System.currentTimeMillis();

    public static void accumulateCraftingData(ServerPlayer player, String itemName, int amount, double experience, SkillType type, Runnable onFinish) {
        CraftingTracker tracker = craftingData.computeIfAbsent(player, key -> new CraftingTracker());
        tracker.setItemName(itemName);
        tracker.addCraftedAmount(amount);
        tracker.addExperience(experience);
        tracker.updateLastEventTime();
        int ping = player.connection.latency();
        int delay = Math.max(600, ping);
        scheduler.schedule(() -> {
            CraftingTracker.sendCraftingSummary(player, type);
            if (onFinish != null) {
                onFinish.run();
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    private static void sendCraftingSummary(ServerPlayer player, SkillType type) {
        CraftingTracker tracker = craftingData.get(player);
        if (tracker != null && tracker.shouldSendMessage()) {
            double roundedXp = (double)Math.round(tracker.getTotalExperience() * 100.0) / 100.0;
            if (tracker.getCraftedAmount() > 1) {
                player.sendSystemMessage((Component)Component.literal((String)("You gained " + roundedXp + " experience for creating " + tracker.getCraftedAmount() + " x " + tracker.getItemName() + "'s.")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)("You gained " + roundedXp + " experience for creating one " + tracker.getItemName() + ".")));
            }
            FloatingTextSender.sendCenteredText(player, "+" + roundedXp + "xp", type);
            craftingData.remove(player);
        }
    }

    private CraftingTracker() {
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void addCraftedAmount(int amount) {
        this.craftedAmount += amount;
    }

    public void addExperience(double experience) {
        this.totalExperience += experience;
    }

    public void updateLastEventTime() {
        this.lastEventTime = System.currentTimeMillis();
    }

    public boolean shouldSendMessage() {
        return System.currentTimeMillis() - this.lastEventTime >= 300L;
    }

    public String getItemName() {
        return this.itemName;
    }

    public int getCraftedAmount() {
        return this.craftedAmount;
    }

    public double getTotalExperience() {
        return this.totalExperience;
    }

    public String toString() {
        return "CraftingTracker{itemName='" + this.itemName + "', craftedAmount=" + this.craftedAmount + ", totalExperience=" + this.totalExperience + ", lastEventTime=" + this.lastEventTime + "}";
    }
}

