/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.raynna.raynnarpg.utils.Colour;

public class MessageSender {
    public static void send(ServerPlayer player, String message) {
        MessageSender.send(player, message, null);
    }

    public static void send(ServerPlayer player, String message, Colour.Colours color) {
        if (color == null) {
            color = Colour.Colours.WHITE;
        }
        player.sendSystemMessage((Component)Component.literal((String)message).setStyle(Style.EMPTY.withColor(color.getTextColor())));
    }

    public static void sendAll(ServerPlayer player, String message) {
        MessageSender.sendAll(player, message, null);
    }

    public static void sendAll(ServerPlayer player, String message, Colour.Colours color) {
        MinecraftServer server;
        if (color == null) {
            color = Colour.Colours.WHITE;
        }
        if ((server = player.getServer()) == null) {
            return;
        }
        for (ServerPlayer otherPlayer : server.getPlayerList().getPlayers()) {
            MessageSender.send(otherPlayer, message, color);
        }
    }

    public static void sendAllButSelf(ServerPlayer player, String message) {
        MessageSender.sendAllButSelf(player, message, null);
    }

    public static void sendAllButSelf(ServerPlayer player, String message, Colour.Colours color) {
        MinecraftServer server;
        if (color == null) {
            color = Colour.Colours.WHITE;
        }
        if ((server = player.getServer()) == null) {
            return;
        }
        for (ServerPlayer otherPlayer : server.getPlayerList().getPlayers()) {
            if (otherPlayer == player) continue;
            MessageSender.send(otherPlayer, message, color);
        }
    }
}

