/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerDamageTracker {
    private static final Map<UUID, Map<UUID, DamageRecord>> damageMap = new ConcurrentHashMap<UUID, Map<UUID, DamageRecord>>();

    public static void recordDamage(ServerPlayer attacker, LivingEntity target, float amount) {
        damageMap.computeIfAbsent(attacker.getUUID(), k -> new ConcurrentHashMap()).compute(target.getUUID(), (k, v) -> {
            if (v == null) {
                return new DamageRecord(amount);
            }
            return v.addDamage(amount);
        });
    }

    public static List<ServerPlayer> getAttackers(LivingEntity entity) {
        return damageMap.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(entity.getUUID())).map(entry -> {
            Player player = entity.level().getPlayerByUUID((UUID)entry.getKey());
            return player instanceof ServerPlayer ? (ServerPlayer)player : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static float getDamageDealt(ServerPlayer player, LivingEntity entity) {
        Map playerDamage = damageMap.getOrDefault(player.getUUID(), Collections.emptyMap());
        DamageRecord record = (DamageRecord)playerDamage.get(entity.getUUID());
        return record == null ? 0.0f : record.totalDamage;
    }

    public static void clearRecords(LivingEntity entity) {
        damageMap.values().forEach(map -> map.remove(entity.getUUID()));
    }

    public static void clearPlayerRecords(ServerPlayer player) {
        int recordsRemoved = damageMap.containsKey(player.getUUID()) ? damageMap.get(player.getUUID()).size() : 0;
        damageMap.remove(player.getUUID());
        System.out.println("[DEBUG] Removed " + recordsRemoved + " damage records for player");
    }

    private static class DamageRecord {
        final float totalDamage;
        final long lastHitTime;

        DamageRecord(float damage) {
            this.totalDamage = damage;
            this.lastHitTime = System.currentTimeMillis();
        }

        DamageRecord addDamage(float additional) {
            return new DamageRecord(this.totalDamage + additional);
        }
    }
}

