/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerUtils {
    public static void removeItemStack(ServerPlayer player, ItemStack toRemove) {
        int count = toRemove.getCount();
        for (int i = 0; i < player.getInventory().getContainerSize() && count > 0; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)toRemove)) continue;
            int removeAmount = Math.min(count, stack.getCount());
            stack.shrink(removeAmount);
            count -= removeAmount;
            if (!stack.isEmpty()) continue;
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        if (count > 0) {
            System.out.println("Warning: Failed to remove " + count + " items");
        }
    }

    public static void removeItem(ServerPlayer player, String id, int amount) {
        Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id));
        int remainingAmount = amount;
        boolean itemRemoved = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack slotStack = player.getInventory().getItem(i);
            if (slotStack.getItem() != targetItem) continue;
            int stackSize = slotStack.getCount();
            if (stackSize <= remainingAmount) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
                if ((remainingAmount -= stackSize) != 0) continue;
                itemRemoved = true;
                break;
            }
            slotStack.setCount(stackSize - remainingAmount);
            player.getInventory().setItem(i, slotStack);
            itemRemoved = true;
            break;
        }
        if (itemRemoved) {
            player.sendSystemMessage((Component)Component.literal((String)(amount + " of " + targetItem.getDescription().getString() + " has been removed.")));
        }
    }
}

