/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RegistryUtils {
    public static String getDisplayName(String key) {
        if (key == null || key.isEmpty()) {
            return "Unknown";
        }
        ResourceLocation id = ResourceLocation.tryParse((String)key);
        if (id == null) {
            return "Invalid Resource Location";
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        if (item != Items.AIR) {
            return new ItemStack((ItemLike)item).getHoverName().getString();
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
        if (block != Blocks.AIR) {
            return new ItemStack((ItemLike)block).getHoverName().getString();
        }
        return "Unknown";
    }

    public static String getItemDisplayName(String key) {
        ResourceLocation id = ResourceLocation.parse((String)key);
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        if (item == null || item == Items.AIR) {
            return "Unknown Item";
        }
        return new ItemStack((ItemLike)item).getHoverName().getString();
    }

    public static String getBlockId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
    }

    public static String getBlockId(BlockState state) {
        return RegistryUtils.getBlockId(state.getBlock());
    }

    public static String getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }
}

