/*
 * Decompiled with CFR 0.152.
 */
package net.raynna.raynnarpg.utils;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.raynna.raynnarpg.RaynnaRPG;
import net.raynna.raynnarpg.client.ui.OverlayManager;
import net.raynna.raynnarpg.client.ui.floating_text.FloatingText;
import net.raynna.raynnarpg.utils.Colour;
import net.raynna.raynnarpg.utils.CooldownManager;

public class Utils {
    private static final Random RANDOM = new Random();

    public static void checkMiningMiss(Player player, BlockPos pos, float range) {
        OverlayManager overlayManager = RaynnaRPG.getOverlayManager();
        boolean canShowMiss = CooldownManager.checkCooldown(player, "miss", 2000L);
        if (canShowMiss) {
            Vec3 randomVec = Utils.randomizeBlockPos(pos, range);
            FloatingText missText = FloatingText.createWorldSpace("Miss!", randomVec.x, randomVec.y, randomVec.z).withColor(Colour.Colours.RED.getTextColor());
            overlayManager.addText(missText);
        }
    }

    public static String extractModId(String key) {
        if (!key.contains(":")) {
            return Utils.capitalize(key.replace("_", " "));
        }
        String itemName = key.split(":")[0];
        String[] parts = itemName.split("_");
        if (parts.length > 0) {
            return Utils.capitalize(parts[0]);
        }
        return key;
    }

    public static boolean isXpCapped(int playerLevel, int levelReq) {
        double difference = playerLevel - levelReq;
        int levelCap = 20;
        return difference >= (double)levelCap;
    }

    public static String extractItemId(String key) {
        if (!key.contains(":")) {
            return Utils.capitalize(key.replace("_", " "));
        }
        String itemName = key.split(":")[1];
        String[] parts = itemName.split("_");
        if (parts.length > 0) {
            return Utils.capitalize(parts[0]);
        }
        return key;
    }

    public static Vec3 randomOffset(float range) {
        return new Vec3((double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range));
    }

    public static Vec3 randomizeBlockPos(BlockPos pos, float range) {
        return new Vec3((double)pos.getX() + 0.5 + (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)pos.getY() + 0.5 + (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)pos.getZ() + 0.5 + (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range));
    }

    public static Vec3 randomizeVec3(Vec3 original, float range) {
        return original.add((double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range), (double)((RANDOM.nextFloat() * 2.0f - 1.0f) * range));
    }

    public static String formatPercentage(double progress) {
        double percent = progress * 100.0;
        if (percent == (double)((int)percent)) {
            return String.format("%d%%", (int)percent);
        }
        if (Math.abs(percent * 10.0 - (double)((int)(percent * 10.0))) < 1.0E-4) {
            return String.format("%.1f%%", percent);
        }
        return String.format("%.2f%%", percent);
    }

    public static String formatNumber(int number) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);
        return formatter.format(number);
    }

    public static String formatNumber(double number) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);
        return formatter.format(number);
    }

    public static String fixItemName(String itemName) {
        int firstDotIndex;
        int secondDotIndex;
        if (((String)itemName).startsWith("item.") && (secondDotIndex = ((String)itemName).indexOf(46, firstDotIndex = ((String)itemName).indexOf(46) + 1)) != -1) {
            String modId = ((String)itemName).substring(firstDotIndex, secondDotIndex);
            itemName = modId + ":" + ((String)itemName).substring(secondDotIndex + 1);
        }
        return itemName;
    }

    public static String capitalize(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }
}

