/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.utility.ShapeBuilder;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InlineOpticalSensorBlock
extends DirectionalBlock
implements EntityBlock,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"redstone_power", (int)0, (int)15);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShaper BLOCK_SHAPE;
    public static final TagKey<Item> CBC_PROJECTILE_ITEM_TAG;
    private static Set<Block> validCbcSupportBlocks;
    private static final Object initLock;

    public InlineOpticalSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new InlineOpticalSensorBlockEntity(null, pos, state);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            level.m_46672_(pos, state.m_60734_());
            level.m_46672_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), state.m_60734_());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        if (pState == null) {
            return BLOCK_SHAPE.get(Direction.NORTH);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = direction.m_122424_();
        }
        return BLOCK_SHAPE.get(direction);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWER});
        builder.m_61104_(new Property[]{POWERED});
        super.m_7926_(builder);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (level.f_46443_) {
            return;
        }
        Direction blockFacing = (Direction)state.m_61143_((Property)FACING);
        if (fromPos.equals((Object)pos.m_121945_(blockFacing.m_122424_())) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    public int m_6378_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_61143_((Property)FACING) == side ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    public int m_6376_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_61143_((Property)FACING) == side ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return (Integer)state.m_61143_((Property)POWER) > 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == state.m_61143_((Property)FACING);
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        Set<Block> projectileBlocks;
        boolean isOnProjectile;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_121945_(facing.m_122424_());
        BlockState supportState = level.m_8055_(supportPos);
        boolean faceIsSturdy = supportState.m_60783_((BlockGetter)level, supportPos, facing);
        if (faceIsSturdy) {
            return true;
        }
        if (CreatePropulsion.CBC_ACTIVE && (isOnProjectile = (projectileBlocks = InlineOpticalSensorBlock.getOrCreateProjectileBlocks()).contains(supportState.m_60734_()))) {
            Direction blockDirection = (Direction)supportState.m_61143_((Property)DirectionalBlock.f_52588_);
            return blockDirection == facing || blockDirection.m_122424_() == facing;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Block> getOrCreateProjectileBlocks() {
        if (validCbcSupportBlocks == null) {
            Object object = initLock;
            synchronized (object) {
                if (validCbcSupportBlocks == null) {
                    if (!CreatePropulsion.CBC_ACTIVE) {
                        validCbcSupportBlocks = Collections.emptySet();
                    } else {
                        HashSet<Block> tempSet = new HashSet<Block>();
                        Optional tagOptional = BuiltInRegistries.f_257033_.m_203431_(CBC_PROJECTILE_ITEM_TAG);
                        HolderSet.Named itemHolders = (HolderSet.Named)tagOptional.get();
                        for (Holder itemHolder : itemHolders) {
                            Item item = (Item)itemHolder.m_203334_();
                            Block block = Block.m_49814_((Item)item);
                            if (block == null || block == Blocks.f_50016_) continue;
                            tempSet.add(block);
                        }
                        validCbcSupportBlocks = tempSet;
                    }
                }
            }
        }
        return validCbcSupportBlocks;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return new SmartBlockEntityTicker();
    }

    static {
        CBC_PROJECTILE_ITEM_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("createbigcannons", "big_cannon_projectiles"));
        validCbcSupportBlocks = null;
        initLock = new Object();
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
        BLOCK_SHAPE = ShapeBuilder.shapeBuilder(shape).forDirectional(Direction.NORTH);
    }
}

