/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlock;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class InlineOpticalSensorBlockEntity
extends SmartBlockEntity {
    private int currentTick = -1;
    private static final int TICK_RATE = 5;
    private static final float RAYCAST_DISTANCE = 16.0f;
    private float raycastDistance = this.getMaxRaycastDistanceNormalized();

    public InlineOpticalSensorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn == null ? (BlockEntityType)CreatePropulsion.INLINE_OPTICAL_SENSOR_BLOCK_ENTITY.get() : typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public float getRaycastDistance() {
        return this.raycastDistance;
    }

    public float getZAxisOffset() {
        return -0.125f;
    }

    protected float getMaxRaycastDistance() {
        return 16.0f;
    }

    private float getMaxRaycastDistanceNormalized() {
        return this.getMaxRaycastDistance() - this.getZAxisOffset() % 0.5f;
    }

    private Vec3 getStartingPoint(Vec3 directionVec) {
        Vec3 base = directionVec.m_82542_((double)this.getZAxisOffset(), (double)this.getZAxisOffset(), (double)this.getZAxisOffset());
        return base.m_82549_(Vec3.m_272021_((Vec3i)this.f_58858_, (double)0.5, (double)0.5, (double)0.5));
    }

    public void tick() {
        super.tick();
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ++this.currentTick;
        if (this.currentTick % 5 != 0) {
            return;
        }
        this.performRaycast(level);
    }

    private void performRaycast(Level level) {
        BlockPos shipLocalPos;
        BlockState state = this.m_58900_();
        BlockPos hitBlockPos = shipLocalPos = this.m_58899_();
        float maxRaycastDistance = this.getMaxRaycastDistanceNormalized();
        Pair<Vec3, Vec3> raycastPositions = this.calculateRaycastPositions(shipLocalPos, (Direction)state.m_61143_((Property)InlineOpticalSensorBlock.FACING), maxRaycastDistance);
        ClipContext context = new ClipContext((Vec3)raycastPositions.getFirst(), (Vec3)raycastPositions.getSecond(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult hit = level.m_45547_(context);
        int newPower = 0;
        float distance = maxRaycastDistance;
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitPos = hit.m_82450_();
            hitBlockPos = hit.m_82425_();
            distance = (float)((Vec3)raycastPositions.getFirst()).m_82554_(hitPos);
            distance = Math.min((float)distance, (float)maxRaycastDistance);
            float invDistancePercent = 1.0f - distance / maxRaycastDistance;
            newPower = Math.round((float)Math.lerp((float)0.0f, (float)15.0f, (float)invDistancePercent));
        }
        this.updateRaycastDistance(level, state, distance);
        this.updateRedstoneSignal(level, state, shipLocalPos, newPower, hitBlockPos);
    }

    private void updateRaycastDistance(Level level, BlockState state, float distance) {
        this.raycastDistance = distance;
        if (!level.m_5776_()) {
            this.m_6596_();
            level.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    private Pair<Vec3, Vec3> calculateRaycastPositions(BlockPos shipLocalPos, Direction facingDirection, float maxRaycastDistance) {
        Vec3 worldDisplacement;
        Vec3 worldFrom;
        Vec3 localDirectionVector = new Vec3(facingDirection.m_253071_());
        Vec3 localFromCenter = this.getStartingPoint(localDirectionVector);
        Vec3 localDisplacement = localDirectionVector.m_82490_((double)maxRaycastDistance);
        LoadedShip ship = null;
        boolean onShip = VSGameUtilsKt.isBlockInShipyard((Level)this.f_58857_, (BlockPos)shipLocalPos);
        if (onShip) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)shipLocalPos);
        }
        if (onShip && ship != null && ship.getTransform() != null) {
            worldFrom = VSGameUtilsKt.toWorldCoordinates((Ship)ship, (Vec3)localFromCenter);
            Quaterniondc shipRotation = ship.getTransform().getShipToWorldRotation();
            Vector3d rotatedDisplacementJOML = new Vector3d();
            shipRotation.transform(localDisplacement.f_82479_, localDisplacement.f_82480_, localDisplacement.f_82481_, rotatedDisplacementJOML);
            worldDisplacement = new Vec3(rotatedDisplacementJOML.x, rotatedDisplacementJOML.y, rotatedDisplacementJOML.z);
        } else {
            worldFrom = localFromCenter;
            worldDisplacement = localDisplacement;
        }
        Vec3 worldTo = worldFrom.m_82549_(worldDisplacement);
        return new Pair((Object)worldFrom, (Object)worldTo);
    }

    protected void updateRedstoneSignal(Level level, BlockState state, BlockPos pos, int newPower, BlockPos hitBlockPos) {
        int oldPower = (Integer)state.m_61143_((Property)InlineOpticalSensorBlock.POWER);
        if (oldPower != newPower) {
            BlockState updatedState = (BlockState)((BlockState)state.m_61124_((Property)InlineOpticalSensorBlock.POWER, (Comparable)Integer.valueOf(newPower))).m_61124_((Property)InlineOpticalSensorBlock.POWERED, (Comparable)Boolean.valueOf(newPower > 0));
            level.m_7731_(pos, updatedState, 3);
            Direction facingDir = (Direction)state.m_61143_((Property)InlineOpticalSensorBlock.FACING);
            BlockPos adjacentPos = pos.m_121945_(facingDir);
            level.m_46672_(adjacentPos, state.m_60734_());
            level.m_46672_(pos.m_121945_(((Direction)state.m_61143_((Property)InlineOpticalSensorBlock.FACING)).m_122424_()), state.m_60734_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("raycastDistance", this.raycastDistance);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.raycastDistance = tag.m_128425_("raycastDistance", 5) ? tag.m_128457_("raycastDistance") : this.getMaxRaycastDistanceNormalized();
    }
}

