/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors.rendering;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.optical_sensors.rendering.OpticalSensorBeamRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OpticalSensorRenderer
extends SafeBlockEntityRenderer<InlineOpticalSensorBlockEntity> {
    private static final float RAY_THICKNESS = 0.25f;
    private static final float START_ALPHA = 0.3f;
    private static final float END_ALPHA = 0.0f;
    private static final Vector4f RAY_COLOR = new Vector4f(0.8f, 0.1f, 0.1f, 1.0f);
    private static final Vector4f RAY_POWERED_COLOR = new Vector4f(0.1f, 0.8f, 0.1f, 1.0f);
    private static final Vector4f START_COLOR = new Vector4f(RAY_COLOR.x(), RAY_COLOR.y(), RAY_COLOR.z(), RAY_COLOR.w() * 0.3f);
    private static final Vector4f START_POWERED_COLOR = new Vector4f(RAY_POWERED_COLOR.x(), RAY_POWERED_COLOR.y(), RAY_POWERED_COLOR.z(), RAY_POWERED_COLOR.w() * 0.3f);
    private static final Vector4f END_COLOR = new Vector4f(RAY_COLOR.x(), RAY_COLOR.y(), RAY_COLOR.z(), RAY_COLOR.w() * 0.0f);
    private static final Vector4f END_POWERED_COLOR = new Vector4f(RAY_POWERED_COLOR.x(), RAY_POWERED_COLOR.y(), RAY_POWERED_COLOR.z(), RAY_POWERED_COLOR.w() * 0.0f);
    private final Vector3f localStartPos = new Vector3f();
    private final Vector3f directionVec = new Vector3f();
    private final Vector3f localEndPos = new Vector3f();
    private final Vector3f worldUp = new Vector3f();
    private final Vector3f sideVector = new Vector3f();
    private final Vector3f upVector = new Vector3f();
    private final Vector3f offset_BL = new Vector3f();
    private final Vector3f offset_BR = new Vector3f();
    private final Vector3f offset_TR = new Vector3f();
    private final Vector3f offset_TL = new Vector3f();
    private final Vector3f sBottomLeft = new Vector3f();
    private final Vector3f sBottomRight = new Vector3f();
    private final Vector3f sTopRight = new Vector3f();
    private final Vector3f sTopLeft = new Vector3f();
    private final Vector3f eBottomLeft = new Vector3f();
    private final Vector3f eBottomRight = new Vector3f();
    private final Vector3f eTopRight = new Vector3f();
    private final Vector3f eTopLeft = new Vector3f();
    private final Vector3f normalBottom = new Vector3f();
    private final Vector3f normalRight = new Vector3f();
    private final Vector3f normalTop = new Vector3f();
    private final Vector3f normalLeft = new Vector3f();
    private static final float HALF_THICKNESS = 0.125f;
    private final Vector3d worldStart = new Vector3d();
    private final Vector3d worldEnd = new Vector3d();

    public OpticalSensorRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(InlineOpticalSensorBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        float distance;
        if (blockEntity.m_58903_() == CreatePropulsion.OPTICAL_SENSOR_BLOCK_ENTITY.get()) {
            FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)blockEntity, (float)partialTicks, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)light, (int)overlay);
        }
        if ((distance = blockEntity.getRaycastDistance()) <= 1.0E-6f) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        boolean powered = (Boolean)state.m_61143_((Property)InlineOpticalSensorBlock.POWERED);
        this.directionVec.set((float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_());
        this.localStartPos.set((Vector3fc)this.directionVec);
        this.localStartPos.mul(blockEntity.getZAxisOffset());
        this.localStartPos.add(0.5f, 0.5f, 0.5f);
        this.directionVec.mul(distance, this.localEndPos);
        this.localEndPos.add((Vector3fc)this.localStartPos);
        this.worldUp.set(0.0f, 1.0f, 0.0f);
        if (Math.abs(this.directionVec.dot((Vector3fc)this.worldUp)) > 0.99f) {
            this.worldUp.set(1.0f, 0.0f, 0.0f);
        }
        this.directionVec.cross((Vector3fc)this.worldUp, this.sideVector).normalize();
        this.directionVec.cross((Vector3fc)this.sideVector, this.upVector).normalize();
        this.sideVector.mul(0.125f);
        this.upVector.mul(0.125f);
        this.offset_BL.set((Vector3fc)this.sideVector).negate().sub((Vector3fc)this.upVector);
        this.offset_BR.set((Vector3fc)this.sideVector).sub((Vector3fc)this.upVector);
        this.offset_TR.set((Vector3fc)this.sideVector).add((Vector3fc)this.upVector);
        this.offset_TL.set((Vector3fc)this.sideVector).negate().add((Vector3fc)this.upVector);
        this.localStartPos.add((Vector3fc)this.offset_BL, this.sBottomLeft);
        this.localStartPos.add((Vector3fc)this.offset_BR, this.sBottomRight);
        this.localStartPos.add((Vector3fc)this.offset_TR, this.sTopRight);
        this.localStartPos.add((Vector3fc)this.offset_TL, this.sTopLeft);
        this.localEndPos.add((Vector3fc)this.offset_BL, this.eBottomLeft);
        this.localEndPos.add((Vector3fc)this.offset_BR, this.eBottomRight);
        this.localEndPos.add((Vector3fc)this.offset_TR, this.eTopRight);
        this.localEndPos.add((Vector3fc)this.offset_TL, this.eTopLeft);
        poseStack.m_85836_();
        VertexConsumer buffer = bufferSource.m_6299_(OpticalSensorBeamRenderType.SOLID_TRANSLUCENT_BEAM);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Vector4f startColor = powered ? START_POWERED_COLOR : START_COLOR;
        Vector4f endColor = powered ? END_POWERED_COLOR : END_COLOR;
        this.normalBottom.set((Vector3fc)this.upVector).negate();
        this.normalRight.set((Vector3fc)this.sideVector);
        this.normalTop.set((Vector3fc)this.upVector);
        this.normalLeft.set((Vector3fc)this.sideVector).negate();
        this.drawQuad(buffer, pose, this.sBottomLeft, this.sBottomRight, this.eBottomRight, this.eBottomLeft, startColor, endColor, this.normalBottom);
        this.drawQuad(buffer, pose, this.sBottomRight, this.sTopRight, this.eTopRight, this.eBottomRight, startColor, endColor, this.normalRight);
        this.drawQuad(buffer, pose, this.sTopRight, this.sTopLeft, this.eTopLeft, this.eTopRight, startColor, endColor, this.normalTop);
        this.drawQuad(buffer, pose, this.sTopLeft, this.sBottomLeft, this.eBottomLeft, this.eTopLeft, startColor, endColor, this.normalLeft);
        poseStack.m_85849_();
    }

    private void drawQuad(VertexConsumer buffer, Matrix4f pose, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector4f startColor, Vector4f endColor, Vector3f normal) {
        buffer.m_252986_(pose, v1.x(), v1.y(), v1.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v2.x(), v2.y(), v2.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v3.x(), v3.y(), v3.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v4.x(), v4.y(), v4.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public boolean shouldRender(@Nonnull InlineOpticalSensorBlockEntity blockEntity, @Nonnull Vec3 cameraPos) {
        BlockPos pos;
        AABB blockAABB;
        if (!super.m_142756_((BlockEntity)blockEntity, cameraPos)) {
            return false;
        }
        Frustum frustum = Minecraft.m_91087_().f_91060_.getFrustum();
        if (frustum.m_113029_(blockAABB = new AABB(pos = blockEntity.m_58899_()).m_82400_(0.125))) {
            return true;
        }
        AABB beamAABB = this.calculateBeamAABB(blockEntity);
        if (beamAABB == null) {
            return false;
        }
        return frustum == null || frustum.m_113029_(beamAABB);
    }

    private AABB calculateBeamAABB(InlineOpticalSensorBlockEntity blockEntity) {
        float distance = blockEntity.getRaycastDistance();
        if (distance <= 1.0E-6f) {
            return null;
        }
        BlockPos blockPos = blockEntity.m_58899_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        this.directionVec.set((float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_());
        this.localStartPos.set((Vector3fc)this.directionVec).mul(blockEntity.getZAxisOffset()).add(0.5f, 0.5f, 0.5f);
        this.worldStart.set((double)((float)blockPos.m_123341_() + this.localStartPos.x()), (double)((float)blockPos.m_123342_() + this.localStartPos.y()), (double)((float)blockPos.m_123343_() + this.localStartPos.z()));
        this.worldEnd.set((Vector3dc)this.worldStart).add((double)(this.directionVec.x * distance), (double)(this.directionVec.y * distance), (double)(this.directionVec.z * distance));
        double minX = Math.min(this.worldStart.x, this.worldEnd.x);
        double minY = Math.min(this.worldStart.y, this.worldEnd.y);
        double minZ = Math.min(this.worldStart.z, this.worldEnd.z);
        double maxX = Math.max(this.worldStart.x, this.worldEnd.x);
        double maxY = Math.max(this.worldStart.y, this.worldEnd.y);
        double maxZ = Math.max(this.worldStart.z, this.worldEnd.z);
        double expansion = 0.125;
        return new AABB(minX -= expansion, minY -= expansion, minZ -= expansion, maxX += expansion, maxY += expansion, maxZ += expansion);
    }

    public boolean shouldRenderOffScreen(@Nonnull InlineOpticalSensorBlockEntity pBlockEntity) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }
}

