/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.particles;

import com.deltasf.createpropulsion.particles.PlumeParticleData;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;

public class PlumeParticle
extends SimpleAnimatedParticle {
    private static final float spread = 0.05f;
    double dx;
    double dy;
    double dz;
    float baseSize;

    protected PlumeParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprite) {
        super(level, x, y, z, sprite, 0.0f);
        this.f_107663_ *= 2.0f;
        this.baseSize = this.f_107663_;
        this.f_107225_ = 38 + this.f_107223_.m_188503_(5);
        this.f_172258_ = 0.99f;
        this.dx = dx + (double)this.gRng();
        this.dy = dy + (double)this.gRng();
        this.dz = dz + (double)this.gRng();
        this.f_107219_ = true;
        this.m_108337_(sprite.m_5819_(0, this.f_107225_));
        this.m_107657_(0xFFFFFF);
        this.m_107271_(1.0f);
    }

    float gRng() {
        return (this.f_107223_.m_188501_() * 2.0f - 1.0f) * 0.05f;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.move();
        this.m_108339_(this.f_107644_);
        float percent = (float)this.f_107224_ / (float)this.f_107225_;
        this.m_107271_(1.0f - percent);
        this.f_107663_ = this.baseSize + (float)Math.pow(percent, 0.8f) * 2.0f;
    }

    private void move() {
        double spmul = 0.144;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            double moveX = this.dx * spmul;
            double moveY = this.dy * spmul;
            double moveZ = this.dz * spmul;
            this.m_6257_(moveX, moveY, moveZ);
            this.dx *= (double)this.f_172258_;
            this.dy *= (double)this.f_172258_;
            this.dz *= (double)this.f_172258_;
            if (this.f_107218_) {
                this.dx *= (double)0.7f;
                this.dz *= (double)0.7f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<PlumeParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull PlumeParticleData data, @Nonnull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new PlumeParticle(level, x, y, z, dx, dy, dz, this.spriteSet);
        }
    }
}

