/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.ship;

import com.deltasf.createpropulsion.ship.IForceApplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class ForceInducedShip
implements ShipForcesInducer {
    public Map<BlockPos, IForceApplier> appliersMapping = new ConcurrentHashMap<BlockPos, IForceApplier>();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl ship = (PhysShipImpl)physicShip;
        this.appliersMapping.forEach((pos, applier) -> applier.applyForces((BlockPos)pos, ship));
    }

    public void addApplier(BlockPos pos, IForceApplier applier) {
        this.appliersMapping.put(pos, applier);
    }

    public void removeApplier(BlockPos pos) {
        this.appliersMapping.remove(pos);
    }

    public static ForceInducedShip getOrCreateAsAttachment(ServerShip ship) {
        ForceInducedShip attachment = (ForceInducedShip)ship.getAttachment(ForceInducedShip.class);
        if (attachment == null) {
            attachment = new ForceInducedShip();
            ship.saveAttachment(ForceInducedShip.class, (Object)attachment);
        }
        return attachment;
    }

    public static ForceInducedShip getOrCreate(ServerShip ship) {
        return ForceInducedShip.getOrCreateAsAttachment(ship);
    }

    public static ForceInducedShip get(Level level, BlockPos pos) {
        ServerShip ship = ForceInducedShip.getShipAt((ServerLevel)level, pos);
        return ship != null ? ForceInducedShip.getOrCreate(ship) : null;
    }

    private static ServerShip getShipAt(ServerLevel serverLevel, BlockPos pos) {
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)pos);
        }
        return ship;
    }
}

