/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.ship.ForceInducedShip;
import com.deltasf.createpropulsion.thruster.ThrusterBlockEntity;
import com.deltasf.createpropulsion.thruster.ThrusterData;
import com.deltasf.createpropulsion.thruster.ThrusterForceApplier;
import com.deltasf.createpropulsion.utility.ShapeBuilder;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import com.simibubi.create.foundation.utility.VoxelShaper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterBlock
extends DirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"redstone_power", (int)0, (int)15);
    public static final VoxelShaper BLOCK_SHAPE;

    public ThrusterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        if (pState == null) {
            return BLOCK_SHAPE.get(Direction.NORTH);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = direction.m_122424_();
        }
        return BLOCK_SHAPE.get(direction);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction baseDirection = context.m_7820_();
        Player player = context.m_43723_();
        Direction placeDirection = player != null ? (!player.m_6144_() ? baseDirection : baseDirection.m_122424_()) : baseDirection.m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDirection);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ThrusterBlockEntity(null, pos, state);
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (!level.m_5776_()) {
            ForceInducedShip ship = ForceInducedShip.get(level, pos);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ThrusterBlockEntity) {
                ThrusterBlockEntity thrusterBlockEntity = (ThrusterBlockEntity)blockEntity;
                if (ship != null) {
                    ThrusterData data = thrusterBlockEntity.getThrusterData();
                    data.setDirection(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122436_()));
                    data.setThrust(0.0f);
                    ThrusterForceApplier applier = new ThrusterForceApplier(data);
                    ship.addApplier(pos, applier);
                }
                this.doRedstoneCheck(level, state, pos);
                this.calculateObstruction(thrusterBlockEntity, level, pos, state);
            }
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity entity;
        ForceInducedShip ship;
        if (!level.m_5776_() && (ship = ForceInducedShip.get(level, pos)) != null) {
            ship.removeApplier(pos);
        }
        if ((entity = level.m_7702_(pos)) != null) {
            ((SmartBlockEntity)entity).destroy();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        this.doRedstoneCheck(level, state, pos);
    }

    private void doRedstoneCheck(Level level, BlockState state, BlockPos pos) {
        int oldRedstonePower;
        int newRedstonePower = level.m_277086_(pos);
        if (newRedstonePower == (oldRedstonePower = ((Integer)state.m_61143_((Property)POWER)).intValue())) {
            return;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newRedstonePower));
        level.m_7731_(pos, newState, 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ThrusterBlockEntity) {
            ThrusterBlockEntity thrusterBlockEntity = (ThrusterBlockEntity)blockEntity;
            this.calculateObstruction(thrusterBlockEntity, level, pos, state);
        }
    }

    private void calculateObstruction(ThrusterBlockEntity thrusterBlockEntity, Level level, BlockPos pos, BlockState state) {
        thrusterBlockEntity.calculateObstruction(level, pos, (Direction)state.m_61143_((Property)FACING));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (cleintLevel, pos, state1, blockEntity) -> {
                if (blockEntity instanceof ThrusterBlockEntity) {
                    ThrusterBlockEntity thrusterBlockEntity = (ThrusterBlockEntity)blockEntity;
                    thrusterBlockEntity.clientTick(cleintLevel, pos, state1, thrusterBlockEntity);
                }
            };
        }
        if (type == CreatePropulsion.THRUSTER_BLOCK_ENTITY.get()) {
            return new SmartBlockEntityTicker();
        }
        return null;
    }

    static {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
        BLOCK_SHAPE = ShapeBuilder.shapeBuilder(shape).forDirectional(Direction.NORTH);
    }
}

