/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.particles.ParticleTypes;
import com.deltasf.createpropulsion.particles.PlumeParticleData;
import com.deltasf.createpropulsion.thruster.ThrusterBlock;
import com.deltasf.createpropulsion.thruster.ThrusterData;
import com.jesz.createdieselgenerators.fluids.FluidRegistry;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class ThrusterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final int OBSTRUCTION_LENGTH = 10;
    private static final int BASE_MAX_THRUST = 200000;
    private ThrusterData thrusterData = new ThrusterData();
    public SmartFluidTankBehaviour tank;
    private BlockState state;
    private int emptyBlocks;
    private static final int TICK_RATE = 10;
    private int currentTick = 0;
    private boolean isThrustDirty = false;
    private ParticleType<PlumeParticleData> particleType;
    private static Set<Fluid> validFluids = new HashSet<Fluid>(){
        {
            if (CreatePropulsion.CDG_ACTIVE) {
                this.add(((ForgeFlowingFluid.Flowing)FluidRegistry.PLANT_OIL.get()).m_5613_());
                this.add(((ForgeFlowingFluid.Flowing)FluidRegistry.BIODIESEL.get()).m_5613_());
                this.add(((ForgeFlowingFluid.Flowing)FluidRegistry.DIESEL.get()).m_5613_());
                this.add(((ForgeFlowingFluid.Flowing)FluidRegistry.GASOLINE.get()).m_5613_());
                this.add(((ForgeFlowingFluid.Flowing)FluidRegistry.ETHANOL.get()).m_5613_());
            } else {
                this.add(Fluids.f_76195_);
            }
        }
    };
    private static Dictionary<Fluid, FluidThrusterProperties> fluidsProperties = new Hashtable<Fluid, FluidThrusterProperties>();

    public ThrusterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super((BlockEntityType)CreatePropulsion.THRUSTER_BLOCK_ENTITY.get(), pos, state);
        this.state = state;
        this.particleType = ParticleTypes.getPlumeType();
    }

    public ThrusterData getThrusterData() {
        return this.thrusterData;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)200);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side == this.state.m_61143_((Property)ThrusterBlock.FACING) && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        super.tick();
        ++this.currentTick;
        if (!this.isThrustDirty && this.currentTick % 10 != 0) {
            return;
        }
        this.state = this.m_58900_();
        if (this.currentTick % 20 == 0) {
            int previousEmptyBlocks = this.emptyBlocks;
            this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)this.state.m_61143_((Property)ThrusterBlock.FACING));
            if (previousEmptyBlocks != this.emptyBlocks) {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.state, this.state, 2);
            }
        }
        this.isThrustDirty = false;
        float thrust = 0.0f;
        int power = (Integer)this.state.m_61143_((Property)ThrusterBlock.POWER);
        if (this.validFluid() && power > 0) {
            FluidThrusterProperties properties = fluidsProperties.get(this.fluidStack().getRawFluid());
            float powerPercentage = (float)power / 15.0f;
            float obstruction = this.calculateObstructionEffect();
            float thrustPercentage = Math.min(powerPercentage, obstruction);
            int consumption = obstruction > 0.0f ? (int)Math.ceil(powerPercentage * properties.consumptionMultiplier * 1.5f * 10.0f) : 0;
            this.tank.getPrimaryHandler().drain(consumption, IFluidHandler.FluidAction.EXECUTE);
            thrust = 200000.0f * thrustPercentage * properties.thrustMultiplier;
        }
        this.thrusterData.setThrust(thrust);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, ThrusterBlockEntity blockEntity) {
        this.emitParticles(level, pos, state, blockEntity);
    }

    private void emitParticles(Level level, BlockPos pos, BlockState state, ThrusterBlockEntity blockEntity) {
        if (blockEntity.emptyBlocks == 0) {
            return;
        }
        int power = (Integer)state.m_61143_((Property)ThrusterBlock.POWER);
        if (power == 0) {
            return;
        }
        if (!this.validFluid()) {
            return;
        }
        float powerPercentage = (float)Math.max(power, 3) / 15.0f;
        float velocity = 4.0f * powerPercentage;
        float shipVelocityModifier = 0.15f;
        Direction direction = (Direction)state.m_61143_((Property)ThrusterBlock.FACING);
        Direction oppositeDirection = direction.m_122424_();
        double particleX = (double)pos.m_123341_() + 0.5 + (double)oppositeDirection.m_122429_() * 0.85;
        double particleY = (double)pos.m_123342_() + 0.5 + (double)oppositeDirection.m_122430_() * 0.85;
        double particleZ = (double)pos.m_123343_() + 0.5 + (double)oppositeDirection.m_122431_() * 0.85;
        Vector3d baseParticleVelocity = new Vector3d((double)oppositeDirection.m_122429_(), (double)oppositeDirection.m_122430_(), (double)oppositeDirection.m_122431_()).mul((double)velocity);
        Vector3d rotatedShipVelocity = new Vector3d();
        ClientShip ship = VSGameUtilsKt.getShipObjectManagingPos((ClientLevel)((ClientLevel)level), (Vec3i)pos);
        if (ship != null) {
            Quaterniondc shipRotation = ship.getRenderTransform().getShipToWorldRotation();
            Quaterniond reversedShipRotation = new Quaterniond(shipRotation).invert();
            Vector3dc shipVelocity = ship.getVelocity();
            reversedShipRotation.transform(shipVelocity, rotatedShipVelocity);
            rotatedShipVelocity.mul((double)shipVelocityModifier);
        }
        baseParticleVelocity.add((Vector3dc)rotatedShipVelocity);
        level.m_6493_((ParticleOptions)new PlumeParticleData(this.particleType), true, particleX, particleY, particleZ, baseParticleVelocity.x, baseParticleVelocity.y, baseParticleVelocity.z);
    }

    private float calculateObstructionEffect() {
        return (float)this.emptyBlocks / 10.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.currentTick == 0 && !this.isThrustDirty) {
            this.calculateObstruction(this.m_58904_(), this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)ThrusterBlock.FACING));
        }
        LangBuilder status = this.fluidStack().isEmpty() ? Lang.translate((String)"gui.goggles.thruster.status.no_fuel", (Object[])new Object[0]).style(ChatFormatting.RED) : (!this.validFluid() ? Lang.translate((String)"gui.goggles.thruster.status.wrong_fuel", (Object[])new Object[0]).style(ChatFormatting.RED) : ((Integer)this.m_58900_().m_61143_((Property)ThrusterBlock.POWER) == 0 ? Lang.translate((String)"gui.goggles.thruster.status.not_powered", (Object[])new Object[0]).style(ChatFormatting.GOLD) : (this.emptyBlocks == 0 ? Lang.translate((String)"gui.goggles.thruster.obstructed", (Object[])new Object[0]).style(ChatFormatting.RED) : Lang.translate((String)"gui.goggles.thruster.status.working", (Object[])new Object[0]).style(ChatFormatting.GREEN))));
        Lang.translate((String)"gui.goggles.thruster.status", (Object[])new Object[0]).text(":").space().add(status).forGoggles(tooltip);
        float efficiency = 100.0f;
        ChatFormatting tooltipColor = ChatFormatting.GREEN;
        if (this.emptyBlocks < 10) {
            efficiency = this.calculateObstructionEffect() * 100.0f;
            tooltipColor = efficiency < 10.0f ? ChatFormatting.RED : (efficiency < 60.0f ? ChatFormatting.GOLD : (efficiency < 100.0f ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            Lang.builder().add(Lang.translate((String)"gui.goggles.thruster.obstructed", (Object[])new Object[0])).space().add(Lang.text((String)ThrusterBlockEntity.makeObstructionBar(this.emptyBlocks, 10))).style(tooltipColor).forGoggles(tooltip);
        }
        Lang.builder().add(Lang.translate((String)"gui.goggles.thruster.efficiency", (Object[])new Object[0])).space().add(Lang.number((double)efficiency)).add(Lang.text((String)"%")).style(tooltipColor).forGoggles(tooltip);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
        return true;
    }

    private FluidStack fluidStack() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    private boolean validFluid() {
        if (this.fluidStack().isEmpty()) {
            return false;
        }
        return validFluids.contains(this.fluidStack().getRawFluid());
    }

    public void calculateObstruction(Level level, BlockPos pos, Direction forwardDirection) {
        BlockPos checkPos;
        BlockState state;
        this.emptyBlocks = 0;
        while (this.emptyBlocks < 10 && ((state = level.m_8055_(checkPos = pos.m_5484_(forwardDirection.m_122424_(), this.emptyBlocks + 1))).m_60795_() || !state.m_280296_())) {
            ++this.emptyBlocks;
        }
        this.isThrustDirty = true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("emptyBlocks", this.emptyBlocks);
        compound.m_128405_("currentTick", this.currentTick);
        compound.m_128379_("isThrustDirty", this.isThrustDirty);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.emptyBlocks = compound.m_128451_("emptyBlocks");
        this.currentTick = compound.m_128451_("currentTick");
        this.isThrustDirty = compound.m_128471_("isThrustDirty");
    }

    public static String makeObstructionBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        for (i = 0; i < length; ++i) {
            bar = (String)bar + "\u2592";
        }
        for (i = 0; i < filledLength - length; ++i) {
            bar = (String)bar + "\u2588";
        }
        return (String)bar + " ";
    }

    static {
        if (CreatePropulsion.CDG_ACTIVE) {
            fluidsProperties.put(((ForgeFlowingFluid.Flowing)FluidRegistry.PLANT_OIL.get()).m_5613_(), new FluidThrusterProperties(0.8f, 1.1f));
            fluidsProperties.put(((ForgeFlowingFluid.Flowing)FluidRegistry.BIODIESEL.get()).m_5613_(), new FluidThrusterProperties(0.9f, 1.0f));
            fluidsProperties.put(((ForgeFlowingFluid.Flowing)FluidRegistry.DIESEL.get()).m_5613_(), new FluidThrusterProperties(1.0f, 0.9f));
            fluidsProperties.put(((ForgeFlowingFluid.Flowing)FluidRegistry.GASOLINE.get()).m_5613_(), new FluidThrusterProperties(1.05f, 0.95f));
            fluidsProperties.put(((ForgeFlowingFluid.Flowing)FluidRegistry.ETHANOL.get()).m_5613_(), new FluidThrusterProperties(0.85f, 1.2f));
        } else {
            fluidsProperties.put((Fluid)Fluids.f_76195_, new FluidThrusterProperties(1.0f, 1.0f));
        }
    }

    private static class FluidThrusterProperties {
        public float thrustMultiplier;
        public float consumptionMultiplier;

        public FluidThrusterProperties(float thrustMultiplier, float consumptionMultiplier) {
            this.thrustMultiplier = thrustMultiplier;
            this.consumptionMultiplier = consumptionMultiplier;
        }
    }
}

