/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.ship.IForceApplier;
import com.deltasf.createpropulsion.thruster.ThrusterData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterForceApplier
implements IForceApplier {
    private ThrusterData data;

    public ThrusterForceApplier(ThrusterData data) {
        this.data = data;
    }

    @Override
    public void applyForces(BlockPos pos, PhysShipImpl ship) {
        double dot;
        float throttle = this.data.getThrust();
        int maxSpeed = 100;
        if (throttle == 0.0f) {
            return;
        }
        Vector3d force = ship.getTransform().getShipToWorld().transformDirection((Vector3dc)this.data.getDirection(), new Vector3d());
        force.mul((double)throttle);
        Vector3dc linearVelocity = ship.getPoseVel().getVel();
        if (linearVelocity.lengthSquared() >= (double)(maxSpeed * maxSpeed) && (dot = force.dot(linearVelocity)) > 0.0) {
            Vector3d tPos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5, new Vector3d()).sub(ship.getTransform().getPositionInShip());
            Vector3d parallel = new Vector3d((Vector3dc)tPos).mul(force.dot((Vector3dc)tPos) / force.dot((Vector3dc)force));
            Vector3d perpendicular = new Vector3d((Vector3dc)force).sub((Vector3dc)parallel);
            ship.applyInvariantForceToPos((Vector3dc)perpendicular, (Vector3dc)tPos);
            ThrusterForceApplier.applyScaledForce(ship, linearVelocity, parallel, maxSpeed);
            return;
        }
        Vector3d tPos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5, new Vector3d()).sub(ship.getTransform().getPositionInShip());
        ship.applyInvariantForceToPos((Vector3dc)force, (Vector3dc)tPos);
    }

    private static void applyScaledForce(PhysShipImpl ship, Vector3dc linearVelocity, Vector3d force, float maxSpeed) {
        assert (ValkyrienSkiesMod.getCurrentServer() != null);
        double deltaTime = 1.0 / VSGameUtilsKt.getVsPipeline((MinecraftServer)ValkyrienSkiesMod.getCurrentServer()).computePhysTps();
        double mass = ship.getInertia().getShipMass();
        Vector3d targetVelocity = new Vector3d(linearVelocity).add((Vector3dc)new Vector3d((Vector3dc)force).mul(deltaTime / mass)).normalize((double)maxSpeed).sub(linearVelocity);
        ship.applyInvariantForce((Vector3dc)targetVelocity.mul(mass / deltaTime));
    }
}

