/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.utility;

import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeBuilder {
    private VoxelShape shape;

    public static ShapeBuilder shapeBuilder(VoxelShape shape) {
        return new ShapeBuilder(shape);
    }

    private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public ShapeBuilder(VoxelShape shape) {
        this.shape = shape;
    }

    public ShapeBuilder add(VoxelShape shape) {
        this.shape = Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)shape);
        return this;
    }

    public ShapeBuilder add(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.add(ShapeBuilder.cuboid(x1, y1, z1, x2, y2, z2));
    }

    public ShapeBuilder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)ShapeBuilder.cuboid(x1, y1, z1, x2, y2, z2), (BooleanOp)BooleanOp.f_82685_);
        return this;
    }

    public VoxelShape build() {
        return this.shape;
    }

    public VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
        return factory.apply(this.shape, direction);
    }

    public VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
        return factory.apply(this.shape, axis);
    }

    public VoxelShaper forDirectional(Direction direction) {
        return this.build(VoxelShaper::forDirectional, direction);
    }

    public VoxelShaper forAxis() {
        return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
    }

    public VoxelShaper forHorizontalAxis() {
        return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
    }

    public VoxelShaper forHorizontal(Direction direction) {
        return this.build(VoxelShaper::forHorizontal, direction);
    }

    public VoxelShaper forDirectional() {
        return this.forDirectional(Direction.UP);
    }
}

