/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.compat.computercraft;

import com.deltasf.createpropulsion.compat.computercraft.LodestoneTrackerPeripheral;
import com.deltasf.createpropulsion.compat.computercraft.MagnetPeripheral;
import com.deltasf.createpropulsion.compat.computercraft.OpticalSensorPeripheral;
import com.deltasf.createpropulsion.compat.computercraft.PhysicsAssemblerPeripheral;
import com.deltasf.createpropulsion.compat.computercraft.ThrusterPeripheral;
import com.deltasf.createpropulsion.lodestone_tracker.LodestoneTrackerBlockEntity;
import com.deltasf.createpropulsion.magnet.RedstoneMagnetBlockEntity;
import com.deltasf.createpropulsion.optical_sensors.OpticalSensorBlockEntity;
import com.deltasf.createpropulsion.physics_assembler.PhysicsAssemblerBlockEntity;
import com.deltasf.createpropulsion.thruster.thruster.ThrusterBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    protected static final Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    LazyOptional<IPeripheral> peripheral;
    NonNullSupplier<IPeripheral> peripheralSupplier;

    public ComputerBehaviour(SmartBlockEntity blockEntity) {
        super(blockEntity);
        this.peripheralSupplier = ComputerBehaviour.getPeripheralFor(blockEntity);
    }

    public static NonNullSupplier<IPeripheral> getPeripheralFor(SmartBlockEntity blockEntity) {
        if (blockEntity instanceof ThrusterBlockEntity) {
            ThrusterBlockEntity thruster = (ThrusterBlockEntity)blockEntity;
            return () -> new ThrusterPeripheral(thruster);
        }
        if (blockEntity instanceof OpticalSensorBlockEntity) {
            OpticalSensorBlockEntity opticalSensor = (OpticalSensorBlockEntity)blockEntity;
            return () -> new OpticalSensorPeripheral(opticalSensor);
        }
        if (blockEntity instanceof LodestoneTrackerBlockEntity) {
            LodestoneTrackerBlockEntity tracker = (LodestoneTrackerBlockEntity)blockEntity;
            return () -> new LodestoneTrackerPeripheral(tracker);
        }
        if (blockEntity instanceof RedstoneMagnetBlockEntity) {
            RedstoneMagnetBlockEntity redstoneMagner = (RedstoneMagnetBlockEntity)blockEntity;
            return () -> new MagnetPeripheral(redstoneMagner);
        }
        if (blockEntity instanceof PhysicsAssemblerBlockEntity) {
            PhysicsAssemblerBlockEntity physicsAssembler = (PhysicsAssemblerBlockEntity)blockEntity;
            return () -> new PhysicsAssemblerPeripheral(physicsAssembler);
        }
        throw new IllegalArgumentException("No peripheral available for " + ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)blockEntity.m_58903_()));
    }

    public <T> boolean isPeripheralCap(Capability<T> cap) {
        return cap == PERIPHERAL_CAPABILITY;
    }

    public <T> LazyOptional<T> getPeripheralCapability() {
        if (this.peripheral == null || !this.peripheral.isPresent()) {
            this.peripheral = LazyOptional.of(this.peripheralSupplier);
        }
        return this.peripheral.cast();
    }

    public void removePeripheral() {
        if (this.peripheral != null) {
            this.peripheral.invalidate();
        }
    }
}

