/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.compat.computercraft;

import com.deltasf.createpropulsion.thruster.thruster.ThrusterBlockEntity;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ThrusterPeripheral
extends SyncedPeripheral<ThrusterBlockEntity> {
    private final FluidMethods fluidMethods = new FluidMethods();

    public ThrusterPeripheral(ThrusterBlockEntity blockEntity) {
        super((SmartBlockEntity)blockEntity);
    }

    public String getType() {
        return "propulsion_thruster";
    }

    @LuaFunction
    public int getObstruction() {
        return ((ThrusterBlockEntity)this.blockEntity).getEmptyBlocks();
    }

    @LuaFunction(mainThread=true)
    public void setPower(int power) {
        int clampedPower = Math.max(Math.min(power, 15), 0);
        if (((ThrusterBlockEntity)this.blockEntity).overridenPower != clampedPower || ((ThrusterBlockEntity)this.blockEntity).overridePower != (clampedPower != 0)) {
            ((ThrusterBlockEntity)this.blockEntity).overridePower = clampedPower != 0;
            ((ThrusterBlockEntity)this.blockEntity).overridenPower = clampedPower;
            ((ThrusterBlockEntity)this.blockEntity).dirtyThrust();
            ((ThrusterBlockEntity)this.blockEntity).m_6596_();
            ((ThrusterBlockEntity)this.blockEntity).sendData();
        }
    }

    @LuaFunction(mainThread=true)
    public String getFuelName() {
        if (((ThrusterBlockEntity)this.blockEntity).fluidStack().isEmpty()) {
            return "";
        }
        return ((ThrusterBlockEntity)this.blockEntity).fluidStack().getDisplayName().getString();
    }

    @LuaFunction(mainThread=true)
    public float getFuelThrustMultiplier() {
        if (!((ThrusterBlockEntity)this.blockEntity).validFluid()) {
            return 0.0f;
        }
        return ((ThrusterBlockEntity)this.blockEntity).getFuelProperties((Fluid)((ThrusterBlockEntity)this.blockEntity).fluidStack().getRawFluid()).thrustMultiplier;
    }

    @LuaFunction(mainThread=true)
    public float getFuelConsumptionMultiplier() {
        if (!((ThrusterBlockEntity)this.blockEntity).validFluid()) {
            return 0.0f;
        }
        return ((ThrusterBlockEntity)this.blockEntity).getFuelProperties((Fluid)((ThrusterBlockEntity)this.blockEntity).fluidStack().getRawFluid()).consumptionMultiplier;
    }

    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> tanks() throws LuaException {
        IFluidHandler handler = this.getHandler();
        return this.fluidMethods.tanks(handler);
    }

    @LuaFunction(mainThread=true)
    public int pushFluid(IComputerAccess computer, String toName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        IFluidHandler handler = this.getHandler();
        return this.fluidMethods.pushFluid(handler, computer, toName, limit, fluidName);
    }

    @LuaFunction(mainThread=true)
    public int pullFluid(IComputerAccess computer, String fromName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        IFluidHandler handler = this.getHandler();
        return this.fluidMethods.pullFluid(handler, computer, fromName, limit, fluidName);
    }

    private IFluidHandler getHandler() throws LuaException {
        return (IFluidHandler)((ThrusterBlockEntity)this.blockEntity).tank.getCapability().orElseThrow(() -> new LuaException("Fluid tank not available"));
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ThrusterPeripheral) {
            ThrusterPeripheral otherThruster = (ThrusterPeripheral)other;
            return this.blockEntity == otherThruster.blockEntity;
        }
        return false;
    }

    public void detach(@NotNull IComputerAccess computer) {
        if (((ThrusterBlockEntity)this.blockEntity).overridePower) {
            ((ThrusterBlockEntity)this.blockEntity).overridePower = false;
            ((ThrusterBlockEntity)this.blockEntity).overridenPower = 0;
            ((ThrusterBlockEntity)this.blockEntity).dirtyThrust();
            ((ThrusterBlockEntity)this.blockEntity).m_6596_();
            ((ThrusterBlockEntity)this.blockEntity).sendData();
        }
        super.detach(computer);
    }
}

