/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.lodestone_tracker;

import com.deltasf.createpropulsion.lodestone_tracker.LodestoneTrackerBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionBlockEntities;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class LodestoneTrackerBlock
extends Block
implements EntityBlock,
IWrenchable {
    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        return PropulsionShapes.LODESTONE_TRACKER.get(Direction.NORTH);
    }

    public LodestoneTrackerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new LodestoneTrackerBlockEntity((BlockEntityType)PropulsionBlockEntities.LODESTONE_TRACKER_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof LodestoneTrackerBlockEntity) {
                LodestoneTrackerBlockEntity trackerBlockEntity = (LodestoneTrackerBlockEntity)be;
                ItemStack compass = trackerBlockEntity.getCompass();
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)compass);
            }
            level.m_46747_(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        boolean playerHoldingCompass;
        if (ray.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof LodestoneTrackerBlockEntity)) {
            return InteractionResult.PASS;
        }
        LodestoneTrackerBlockEntity trackerBlockEntity = (LodestoneTrackerBlockEntity)be;
        ItemStack heldStack = player.m_21120_(hand);
        boolean trackerHasCompass = trackerBlockEntity.hasCompass();
        boolean bl = playerHoldingCompass = heldStack.m_41720_() == Items.f_42522_;
        if (playerHoldingCompass && !trackerHasCompass) {
            Direction insertionDirection;
            ItemStack compassToPlace = heldStack.m_41620_(1);
            Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
            if (ship != null) {
                Vec3 playerLookWorld = player.m_20154_();
                Vector3d playerLookWorldJoml = new Vector3d(playerLookWorld.f_82479_, playerLookWorld.f_82480_, playerLookWorld.f_82481_);
                Vector3d playerLookShipJoml = ship.getWorldToShip().transformDirection((Vector3dc)playerLookWorldJoml, new Vector3d());
                double relativeYawRadians = Math.atan2(-playerLookShipJoml.x, playerLookShipJoml.z);
                double relativeYawDegrees = Math.toDegrees(relativeYawRadians);
                insertionDirection = Direction.m_122364_((double)relativeYawDegrees);
            } else {
                insertionDirection = player.m_6350_();
            }
            trackerBlockEntity.setCompass(compassToPlace, insertionDirection);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(level, (Vec3i)pos);
            this.dirtyBlockEntity(level, pos);
            return InteractionResult.CONSUME;
        }
        if (heldStack.m_41619_() && trackerHasCompass) {
            ItemStack takenCompass = trackerBlockEntity.removeCompass();
            player.m_150109_().m_150079_(takenCompass);
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
            this.dirtyBlockEntity(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void dirtyBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LodestoneTrackerBlockEntity) {
            LodestoneTrackerBlockEntity trackerBlockEntity = (LodestoneTrackerBlockEntity)blockEntity;
            trackerBlockEntity.isOutputDirty = true;
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return new SmartBlockEntityTicker();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockEntity be = level.m_7702_(context.m_8083_());
        if (be instanceof LodestoneTrackerBlockEntity) {
            LodestoneTrackerBlockEntity trackerBlockEntity = (LodestoneTrackerBlockEntity)be;
            trackerBlockEntity.toggleInverted();
            if (trackerBlockEntity.IsInverted()) {
                level.m_5594_(null, context.m_8083_(), SoundEvents.f_12443_, SoundSource.BLOCKS, 0.7f, 0.8f);
            } else {
                IWrenchable.playRotateSound((Level)level, (BlockPos)context.m_8083_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != Direction.DOWN && side != Direction.UP;
    }

    public int m_6378_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        BlockEntity be = blockAccess.m_7702_(pos);
        if (be instanceof LodestoneTrackerBlockEntity) {
            LodestoneTrackerBlockEntity trackerBlockEntity = (LodestoneTrackerBlockEntity)be;
            boolean invertedDirection = trackerBlockEntity.IsInverted();
            if (invertedDirection) {
                if (side == Direction.NORTH) {
                    return trackerBlockEntity.powerNorth();
                }
                if (side == Direction.EAST) {
                    return trackerBlockEntity.powerEast();
                }
                if (side == Direction.SOUTH) {
                    return trackerBlockEntity.powerSouth();
                }
                if (side == Direction.WEST) {
                    return trackerBlockEntity.powerWest();
                }
            } else {
                if (side == Direction.NORTH) {
                    return trackerBlockEntity.powerSouth();
                }
                if (side == Direction.EAST) {
                    return trackerBlockEntity.powerWest();
                }
                if (side == Direction.SOUTH) {
                    return trackerBlockEntity.powerNorth();
                }
                if (side == Direction.WEST) {
                    return trackerBlockEntity.powerEast();
                }
            }
        }
        return 0;
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }
}

