/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.lodestone_tracker;

import com.deltasf.createpropulsion.lodestone_tracker.LodestoneTrackerBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionPartialModels;
import com.deltasf.createpropulsion.utility.Bakery;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LodestoneTrackerRenderer
extends SafeBlockEntityRenderer<LodestoneTrackerBlockEntity> {
    public LodestoneTrackerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(LodestoneTrackerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ItemStack compass = blockEntity.getCompass();
        if (!compass.m_41619_()) {
            float targetAngle = blockEntity.getAngleFromCompass(compass);
            Direction facing = blockEntity.getCompassFacing();
            float facingAngle = facing.m_122435_();
            int modelIndex = this.getIndexFromAngle(targetAngle - facingAngle);
            LodestoneTrackerRenderer.renderCompass(blockEntity.m_58904_(), poseStack, bufferSource, light, overlay, compass, new Vec3(0.5, (double)0.85f, 0.5), modelIndex, facingAngle);
        }
        BlockState blockState = blockEntity.m_58900_();
        VertexConsumer vertexBuffer = bufferSource.m_6299_(RenderType.m_110463_());
        SuperByteBuffer partialIndicatorModel = CachedBuffers.partial((PartialModel)PropulsionPartialModels.LODESTONE_TRACKER_INDICATOR, (BlockState)blockState);
        int[] powers = blockEntity.IsInverted() ? new int[]{blockEntity.powerSouth(), blockEntity.powerEast(), blockEntity.powerNorth(), blockEntity.powerWest()} : new int[]{blockEntity.powerNorth(), blockEntity.powerWest(), blockEntity.powerSouth(), blockEntity.powerEast()};
        for (int i = 0; i < 4; ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 90.0f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            float redstonePower = (float)powers[i] / 15.0f;
            int color = Color.mixColors((int)4653314, (int)0xCD0000, (float)redstonePower);
            partialIndicatorModel.light(light).color(color).renderInto(poseStack, vertexBuffer);
            poseStack.m_85849_();
        }
    }

    private int getIndexFromAngle(float targetAngle) {
        int TOTAL_INDICES = 32;
        float SLICE_SIZE = 11.25f;
        float normalizedAngle = (targetAngle % 360.0f + 360.0f) % 360.0f;
        int index = (int)(normalizedAngle / 11.25f);
        return index;
    }

    private static void renderCompass(Level level, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack item, Vec3 position, int modelIndex, float facingAngle) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        modelIndex = Math.min(Math.max(0, modelIndex), 31);
        BakedModel model = Bakery.BAKED_COMPASS_MODELS[modelIndex];
        ms.m_85836_();
        ms.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        ms.m_252781_(Axis.f_252436_.m_252977_(-facingAngle));
        ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        ms.m_85841_(0.5f, 0.5f, 0.5f);
        itemRenderer.m_115143_(item, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, model);
        ms.m_85849_();
    }
}

