/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.magnet;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.magnet.MagnetPair;
import com.deltasf.createpropulsion.magnet.MagnetRegistry;
import com.deltasf.createpropulsion.utility.AttachmentUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class MagnetForceAttachment
implements ShipForcesInducer {
    public volatile Level level;
    private final Vector3d localPosA_absolute_shipspace = new Vector3d();
    private final Vector3d worldPosA = new Vector3d();
    private final Vector3d m_A_hat = new Vector3d();
    private final Vector3d worldPosB = new Vector3d();
    private final Vector3d m_B_hat = new Vector3d();
    private final Vector3d localPosB_shipspace = new Vector3d();
    private final Vector3d r_AB_vec = new Vector3d();
    private final Vector3d r_BA_vec = new Vector3d();
    private final Vector3d r_BA_hat = new Vector3d();
    private final Vector3d forceOnA = new Vector3d();
    private final Vector3d forceTerm1 = new Vector3d();
    private final Vector3d forceTerm2 = new Vector3d();
    private final Vector3d forceTerm3 = new Vector3d();
    private final Vector3d torqueOnA_dipole = new Vector3d();
    private final Vector3d torqueCross_mA_mB = new Vector3d();
    private final Vector3d torqueCross_mA_rBA = new Vector3d();
    private final Vector3d torqueTerm2_scaled = new Vector3d();
    private final Vector3d worldLeverArmA = new Vector3d();
    private final Vector3d leverArmA_shipSpace = new Vector3d();
    private final Vector3d normalToWorld = new Vector3d();
    private final double MIN_INTERACTION_DISTANCE_SQ = 0.5;
    private final double MAGNET_INTERACTION_CONSTANT = 10000.0;
    private static final double POINT_FIVE = 0.5;
    private final Vector3d accumulatedForce = new Vector3d();
    private final Vector3d accumulatedTorque = new Vector3d();
    private final Vector3d tempTorqueFromForce = new Vector3d();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl ship = (PhysShipImpl)physicShip;
        List<MagnetPair> pairs = MagnetRegistry.forLevel(this.level).getPairsForShip(ship.getId());
        if (pairs.isEmpty()) {
            return;
        }
        ShipTransform transform = ship.getTransform();
        Vector3dc shipCOM = transform.getPositionInShip();
        this.accumulatedForce.zero();
        this.accumulatedTorque.zero();
        for (MagnetPair pair : pairs) {
            this.calculateInteraction(pair, ship, shipCOM, transform, this.accumulatedForce, this.accumulatedTorque);
        }
        if (this.accumulatedForce.lengthSquared() > 1.0E-9) {
            ship.applyInvariantForce((Vector3dc)this.accumulatedForce);
        }
        if (this.accumulatedTorque.lengthSquared() > 1.0E-9) {
            ship.applyInvariantTorque((Vector3dc)this.accumulatedTorque);
        }
    }

    private double force_distance_factor(double distance) {
        return 1.0 / (distance * distance * distance * distance);
    }

    private double torque_distance_factor(double distance) {
        return 1.0 / (distance * distance * distance * distance);
    }

    private void calculateInteraction(MagnetPair pair, PhysShipImpl shipA, Vector3dc ACOM, ShipTransform transformA, Vector3d totalForceAcc, Vector3d totalTorqueAcc) {
        double powerA = pair.localPower;
        double powerB = pair.otherPower;
        if (powerA <= 0.0 || powerB <= 0.0) {
            return;
        }
        double normalizedPowerProduct = powerA / 15.0 * (powerB / 15.0);
        double effectiveInteractionConstant = 10000.0 * normalizedPowerProduct * (Double)PropulsionConfig.REDSTONE_MAGNET_POWER_MULTIPLIER.get();
        this.localPosA_absolute_shipspace.set((double)pair.localPos.m_123341_() + 0.5, (double)pair.localPos.m_123342_() + 0.5, (double)pair.localPos.m_123343_() + 0.5);
        transformA.getShipToWorld().transformPosition((Vector3dc)this.localPosA_absolute_shipspace, this.worldPosA);
        this.toWorldDirection(transformA, (Vector3ic)pair.localDir, this.m_A_hat);
        LoadedShip shipB_loaded = null;
        if (pair.otherShipId == -1L) {
            this.worldPosB.set((double)pair.otherPos.m_123341_() + 0.5, (double)pair.otherPos.m_123342_() + 0.5, (double)pair.otherPos.m_123343_() + 0.5);
            this.m_B_hat.set((double)pair.otherDir.x(), (double)pair.otherDir.y(), (double)pair.otherDir.z());
            if (this.m_B_hat.lengthSquared() < 1.0E-9) {
                System.err.println("Magnet otherDir (world) is zero for magnet at " + pair.otherPos.toString() + ". This will result in NaN forces/torques.");
            }
            this.m_B_hat.normalize();
        } else {
            shipB_loaded = MagnetForceAttachment.getShipById(this.level, pair.otherShipId);
            if (shipB_loaded == null) {
                return;
            }
            ShipTransform transformB = shipB_loaded.getTransform();
            this.localPosB_shipspace.set((double)pair.otherPos.m_123341_() + 0.5, (double)pair.otherPos.m_123342_() + 0.5, (double)pair.otherPos.m_123343_() + 0.5);
            transformB.getShipToWorld().transformPosition((Vector3dc)this.localPosB_shipspace, this.worldPosB);
            this.toWorldDirection(transformB, (Vector3ic)pair.otherDir, this.m_B_hat);
        }
        this.worldPosB.sub((Vector3dc)this.worldPosA, this.r_AB_vec);
        double rLengthSquared = this.r_AB_vec.lengthSquared();
        if (rLengthSquared > 1024.0) {
            return;
        }
        double effectiveRSquared = Math.max((double)rLengthSquared, (double)0.5);
        double effectiveR = Math.sqrt((double)effectiveRSquared);
        if (effectiveR <= 1.0E-8) {
            return;
        }
        this.r_AB_vec.negate(this.r_BA_vec);
        this.r_BA_vec.normalize(effectiveR, this.r_BA_hat);
        double forceCoeff = 3.0 * effectiveInteractionConstant * this.force_distance_factor(effectiveR);
        double torqueCoeff = effectiveInteractionConstant * this.torque_distance_factor(effectiveR);
        double dot_mA_rBA = this.m_A_hat.dot((Vector3dc)this.r_BA_hat);
        double dot_mB_rBA = this.m_B_hat.dot((Vector3dc)this.r_BA_hat);
        double dot_mA_mB = this.m_A_hat.dot((Vector3dc)this.m_B_hat);
        this.m_B_hat.mul(dot_mA_rBA, this.forceTerm1);
        this.m_A_hat.mul(dot_mB_rBA, this.forceTerm2);
        double termF3_scalar = dot_mA_mB - 5.0 * dot_mA_rBA * dot_mB_rBA;
        this.r_BA_hat.mul(termF3_scalar, this.forceTerm3);
        this.forceTerm1.add((Vector3dc)this.forceTerm2, this.forceOnA);
        this.forceOnA.add((Vector3dc)this.forceTerm3);
        this.forceOnA.mul(forceCoeff);
        this.m_A_hat.cross((Vector3dc)this.m_B_hat, this.torqueCross_mA_mB);
        this.m_A_hat.cross((Vector3dc)this.r_BA_hat, this.torqueCross_mA_rBA);
        this.torqueCross_mA_rBA.mul(-3.0 * dot_mB_rBA, this.torqueTerm2_scaled);
        this.torqueCross_mA_mB.add((Vector3dc)this.torqueTerm2_scaled, this.torqueOnA_dipole);
        this.torqueOnA_dipole.mul(torqueCoeff);
        this.torqueOnA_dipole.negate();
        if (!this.forceOnA.isFinite() || !this.torqueOnA_dipole.isFinite()) {
            return;
        }
        this.localPosA_absolute_shipspace.sub(ACOM, this.leverArmA_shipSpace);
        transformA.getShipToWorld().transformDirection((Vector3dc)this.leverArmA_shipSpace, this.worldLeverArmA);
        this.worldLeverArmA.cross((Vector3dc)this.forceOnA, this.tempTorqueFromForce);
        totalForceAcc.add((Vector3dc)this.forceOnA);
        totalTorqueAcc.add((Vector3dc)this.torqueOnA_dipole);
        totalTorqueAcc.add((Vector3dc)this.tempTorqueFromForce.mul(((Double)PropulsionConfig.REDSTONE_MAGNET_FORCE_INDUCED_TORQUE_MULTIPLIER.get()).doubleValue()));
    }

    private void toWorldDirection(ShipTransform transform, Vector3ic blockNormal, Vector3d destWorldDir) {
        this.normalToWorld.set(blockNormal);
        transform.getShipToWorld().transformDirection((Vector3dc)this.normalToWorld, destWorldDir);
        if (destWorldDir.lengthSquared() < 1.0E-10) {
            destWorldDir.zero();
            return;
        }
        destWorldDir.normalize();
    }

    public static LoadedShip getShipById(Level level, long shipId) {
        return (LoadedShip)VSGameUtilsKt.getShipWorldNullable((Level)level).getLoadedShips().getById(shipId);
    }

    public static MagnetForceAttachment getOrCreateAsAttachment(Level level, ServerShip ship) {
        return AttachmentUtils.getOrCreate(ship, MagnetForceAttachment.class, () -> {
            MagnetForceAttachment attachment = new MagnetForceAttachment();
            attachment.level = level;
            return attachment;
        });
    }

    public static MagnetForceAttachment get(Level level, BlockPos pos) {
        return AttachmentUtils.get(level, pos, MagnetForceAttachment.class, () -> {
            MagnetForceAttachment attachment = new MagnetForceAttachment();
            attachment.level = level;
            return attachment;
        });
    }

    public static void ensureAttachmentExists(@Nonnull Level level, @Nonnull BlockPos pos) {
        MagnetForceAttachment.get(level, pos);
    }
}

