/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.magnet;

import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.compat.computercraft.ComputerBehaviour;
import com.deltasf.createpropulsion.magnet.MagnetData;
import com.deltasf.createpropulsion.magnet.MagnetForceAttachment;
import com.deltasf.createpropulsion.magnet.MagnetRegistry;
import com.deltasf.createpropulsion.magnet.RedstoneMagnetBlock;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Vector3i;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class RedstoneMagnetBlockEntity
extends SmartBlockEntity {
    private UUID magnetId;
    private boolean needsUpdate = true;
    private int power = 0;
    public AbstractComputerBehaviour computerBehaviour;
    public boolean overridePower = false;
    public int overridenPower;

    public RedstoneMagnetBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void setPower(int power) {
        if (this.power == power) {
            return;
        }
        this.power = power;
        if (!this.overridePower) {
            this.scheduleUpdate();
        }
        this.m_6596_();
    }

    public void updateMagnetState() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.magnetId == null) {
            this.magnetId = UUID.randomUUID();
            this.m_6596_();
        }
        BlockState currentState = this.f_58857_.m_8055_(this.f_58858_);
        int effectivePower = this.getEffectivePower();
        if (effectivePower > 0) {
            long currentShipId = -1L;
            Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)this.f_58858_);
            if (ship != null) {
                currentShipId = ship.getId();
                MagnetForceAttachment.ensureAttachmentExists(this.f_58857_, this.f_58858_);
            }
            Vector3i currentDipoleDir = VectorConversionsMCKt.toJOML((Vec3i)((Direction)currentState.m_61143_((Property)RedstoneMagnetBlock.FACING)).m_122436_());
            MagnetData magnetData = MagnetRegistry.forLevel(this.f_58857_).getOrCreateMagnet(this.magnetId, this.f_58858_, currentShipId, currentDipoleDir, effectivePower);
            magnetData.cancelRemoval();
            magnetData.update(this.f_58858_, currentShipId, currentDipoleDir, effectivePower);
            MagnetRegistry.forLevel(this.f_58857_).updateMagnetPosition(magnetData);
        } else {
            MagnetRegistry.forLevel(this.f_58857_).scheduleRemoval(this.magnetId);
        }
    }

    public void scheduleUpdate() {
        this.needsUpdate = true;
    }

    public void onBlockBroken() {
        if (this.magnetId != null) {
            MagnetRegistry.forLevel(this.f_58857_).scheduleRemoval(this.magnetId);
        }
    }

    public void tick() {
        MagnetData data;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.needsUpdate) {
            this.updateMagnetState();
            this.needsUpdate = false;
        }
        if ((data = MagnetRegistry.forLevel(this.f_58857_).getMagnet(this.magnetId)) != null && data.shipId != -1L) {
            ServerShip serverShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_);
            if (serverShip == null) {
                MagnetRegistry.forLevel(this.f_58857_).removeAllMagnetsForShip(data.shipId);
            } else {
                MagnetRegistry.forLevel(this.f_58857_).updateMagnetPosition(data);
            }
        }
    }

    public void onLoad() {
        this.scheduleUpdate();
    }

    public int getEffectivePower() {
        if (PropulsionCompatibility.CC_ACTIVE && this.overridePower) {
            return this.overridenPower;
        }
        return this.power;
    }

    public void updateBlockstateFromPower() {
        boolean shouldBePowered;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState currentState = this.m_58900_();
        boolean bl = shouldBePowered = this.getEffectivePower() > 0;
        if ((Boolean)currentState.m_61143_((Property)RedstoneMagnetBlock.POWERED) != shouldBePowered) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)currentState.m_61124_((Property)RedstoneMagnetBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 2);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.computerBehaviour = new ComputerBehaviour(this);
            behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (PropulsionCompatibility.CC_ACTIVE && this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag tag, boolean isClient) {
        super.read(tag, isClient);
        if (tag.m_128403_("MagnetId")) {
            this.magnetId = tag.m_128342_("MagnetId");
        }
        this.power = tag.m_128451_("Power");
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.overridePower = tag.m_128471_("overridePower");
            this.overridenPower = tag.m_128451_("overridenPower");
        }
    }

    protected void write(CompoundTag tag, boolean isClient) {
        super.write(tag, isClient);
        if (this.magnetId == null) {
            this.magnetId = UUID.randomUUID();
        }
        tag.m_128362_("MagnetId", this.magnetId);
        tag.m_128405_("Power", this.power);
        if (PropulsionCompatibility.CC_ACTIVE) {
            tag.m_128379_("overridePower", this.overridePower);
            tag.m_128405_("overridenPower", this.overridenPower);
        }
    }
}

