/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.mixin.plugin;

import com.deltasf.createpropulsion.mixin.plugin.MixinIf;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PropulsionMixinPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Supplier<Boolean>> CONDITIONS = new HashMap<String, Supplier<Boolean>>();

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            ClassNode mixinClassNode = this.getClassNode(mixinClassName);
            String condition = this.getAnnotationValue(mixinClassNode, MixinIf.class);
            if (condition == null) {
                return true;
            }
            Supplier<Boolean> conditionSupplier = CONDITIONS.get(condition);
            if (conditionSupplier == null) {
                throw new RuntimeException("Unknown mixin condition '" + condition + "' for mixin " + mixinClassName);
            }
            System.out.println("Mixin " + mixinClassName + "is " + (conditionSupplier.get() != false ? "applied" : "not applied"));
            return conditionSupplier.get();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read mixin class " + mixinClassName, e);
        }
    }

    private ClassNode getClassNode(String className) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream classInputStream = PropulsionMixinPlugin.class.getClassLoader().getResourceAsStream(resourceName);
        if (classInputStream == null) {
            throw new IOException("Could not find class " + className);
        }
        ClassReader classReader = new ClassReader(classInputStream);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        classInputStream.close();
        return classNode;
    }

    private <T> String getAnnotationValue(ClassNode classNode, Class<T> annotationClass) {
        String annotationDescriptor = "L" + annotationClass.getName().replace('.', '/') + ";";
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.visibleAnnotations) {
                if (!annotation.desc.equals(annotationDescriptor) || annotation.values == null || annotation.values.size() < 2) continue;
                return (String)annotation.values.get(1);
            }
        }
        return null;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        CONDITIONS.put("is_vsaddition_not_loaded", () -> FMLLoader.getLoadingModList().getModFileById("vs_addition") == null);
    }
}

