/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.OpticalLensItem;
import com.deltasf.createpropulsion.optical_sensors.rendering.BeamRenderData;
import com.deltasf.createpropulsion.registries.PropulsionItems;
import com.deltasf.createpropulsion.utility.GoggleUtils;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class AbstractOpticalSensorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private int currentTick = -1;
    protected float raycastDistance = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    private BeamRenderData beamRenderData;
    protected NonNullList<ItemStack> lenses = NonNullList.m_122780_((int)this.getLensLimit(), (Object)ItemStack.f_41583_);
    public static final String NBT_LENSES_KEY = "Lenses";

    @OnlyIn(value=Dist.CLIENT)
    public BeamRenderData getClientBeamRenderData() {
        if (this.beamRenderData == null) {
            this.beamRenderData = new BeamRenderData();
        }
        return this.beamRenderData;
    }

    public float getRaycastDistance() {
        return this.raycastDistance;
    }

    protected AbstractOpticalSensorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public abstract void addBehaviours(List<BlockEntityBehaviour> var1);

    public abstract float getZAxisOffset();

    protected abstract float getMaxRaycastDistance();

    protected abstract int getLensLimit();

    protected abstract void updateRedstoneSignal(@Nonnull Level var1, @Nonnull BlockState var2, @Nonnull BlockPos var3, int var4, @Nullable BlockPos var5);

    public void tick() {
        super.tick();
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ++this.currentTick;
        if (this.currentTick % (Integer)PropulsionConfig.OPTICAL_SENSOR_TICKS_PER_UPDATE.get() != 0) {
            return;
        }
        if (this.currentTick >= (Integer)PropulsionConfig.OPTICAL_SENSOR_TICKS_PER_UPDATE.get()) {
            this.currentTick = 0;
        }
        this.performRaycast(level);
    }

    protected Vec3 getStartingPoint(Vec3 directionVec) {
        Vec3 blockCenter = Vec3.m_272021_((Vec3i)this.f_58858_, (double)0.5, (double)0.5, (double)0.5);
        Vec3 offset = directionVec.m_82542_((double)this.getZAxisOffset(), (double)this.getZAxisOffset(), (double)this.getZAxisOffset());
        return blockCenter.m_82549_(offset);
    }

    private void performRaycast(@Nonnull Level level) {
        BlockState state = this.m_58900_();
        BlockPos currentBlockPos = this.m_58899_();
        Direction facingDirection = (Direction)state.m_61143_((Property)AbstractOpticalSensorBlock.FACING);
        Vec3 localDirectionVector = new Vec3(facingDirection.m_253071_());
        float effectiveMaxDistance = this.getMaxRaycastDistance();
        Pair<Vec3, Vec3> raycastPositions = this.calculateRaycastPositions(currentBlockPos, localDirectionVector, effectiveMaxDistance);
        Vec3 worldFrom = (Vec3)raycastPositions.getFirst();
        Vec3 worldTo = (Vec3)raycastPositions.getSecond();
        ClipContext.Fluid clipFluid = this.hasLens((Item)PropulsionItems.FLUID_LENS.get()) ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE;
        ClipContext context = new ClipContext(worldFrom, worldTo, ClipContext.Block.COLLIDER, clipFluid, null);
        BlockHitResult hit = level.m_45547_(context);
        int rawNewPower = 0;
        float distance = effectiveMaxDistance;
        BlockPos hitBlockPos = null;
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitPos = hit.m_82450_();
            hitBlockPos = hit.m_82425_();
            distance = (float)worldFrom.m_82554_(hitPos);
            distance = Math.min(distance, effectiveMaxDistance);
            float invDistancePercent = 1.0f - distance / effectiveMaxDistance;
            rawNewPower = Math.round(org.joml.Math.lerp((float)0.0f, (float)15.0f, (float)invDistancePercent));
        }
        this.updateRaycastDistance(level, state, distance);
        this.updateRedstoneSignal(level, state, currentBlockPos, rawNewPower, hitBlockPos);
    }

    private void updateRaycastDistance(@Nonnull Level level, @Nonnull BlockState state, float distance) {
        if (Math.abs(this.raycastDistance - distance) > 0.01f) {
            this.raycastDistance = distance;
            this.m_6596_();
            if (!level.m_5776_()) {
                level.m_7260_(this.f_58858_, state, state, 3);
            }
        }
    }

    private Pair<Vec3, Vec3> calculateRaycastPositions(BlockPos localBlockPos, Vec3 localDirectionVector, float maxRaycastDistance) {
        Vec3 worldDisplacement;
        Vec3 worldFrom;
        Level level = this.m_58904_();
        Vec3 localFromCenter = this.getStartingPoint(localDirectionVector);
        Vec3 localDisplacement = localDirectionVector.m_82490_((double)maxRaycastDistance);
        boolean onShip = VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)localBlockPos);
        if (onShip) {
            LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)localBlockPos);
            if (ship != null && ship.getTransform() != null) {
                worldFrom = VSGameUtilsKt.toWorldCoordinates((Ship)ship, (Vec3)localFromCenter);
                Quaterniondc shipRotation = ship.getTransform().getShipToWorldRotation();
                Vector3d rotatedDisplacementJOML = new Vector3d();
                shipRotation.transform(localDisplacement.f_82479_, localDisplacement.f_82480_, localDisplacement.f_82481_, rotatedDisplacementJOML);
                worldDisplacement = new Vec3(rotatedDisplacementJOML.x, rotatedDisplacementJOML.y, rotatedDisplacementJOML.z);
            } else {
                worldFrom = localFromCenter;
                worldDisplacement = localDisplacement;
            }
        } else {
            worldFrom = localFromCenter;
            worldDisplacement = localDisplacement;
        }
        Vec3 worldTo = worldFrom.m_82549_(worldDisplacement);
        return new Pair((Object)worldFrom, (Object)worldTo);
    }

    public NonNullList<ItemStack> getLenses() {
        return this.lenses;
    }

    public int getCurrentLensCount() {
        int count = 0;
        for (ItemStack stack : this.lenses) {
            if (stack.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasSpaceForLens() {
        return this.getCurrentLensCount() < this.getLensLimit();
    }

    public boolean canInsertLens(ItemStack lensStack) {
        if (lensStack.m_41619_() || !lensStack.m_204117_(PropulsionItems.OPTICAL_LENS_TAG)) {
            return false;
        }
        return this.hasSpaceForLens();
    }

    public boolean insertLens(ItemStack lensStack) {
        if (!this.canInsertLens(lensStack)) {
            return false;
        }
        for (int i = 0; i < this.lenses.size(); ++i) {
            if (!((ItemStack)this.lenses.get(i)).m_41619_()) continue;
            ItemStack stackToInsert = lensStack.m_41777_();
            stackToInsert.m_41764_(1);
            this.lenses.set(i, (Object)stackToInsert);
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            lensStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public boolean canExtractLens() {
        return this.getCurrentLensCount() > 0;
    }

    public ItemStack extractLastLens() {
        if (!this.canExtractLens()) {
            return ItemStack.f_41583_;
        }
        for (int i = this.lenses.size() - 1; i >= 0; --i) {
            if (((ItemStack)this.lenses.get(i)).m_41619_()) continue;
            ItemStack extractedStack = (ItemStack)this.lenses.get(i);
            this.lenses.set(i, (Object)ItemStack.f_41583_);
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            return extractedStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean hasLens(Item lensItem) {
        if (this.lenses == null) {
            return false;
        }
        for (ItemStack stack : this.lenses) {
            if (stack.m_41720_() != lensItem) continue;
            return true;
        }
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getCurrentLensCount() == 0) {
            return false;
        }
        CreateLang.builder().add(CreateLang.translate((String)"gui.goggles.optical_sensor.lenses", (Object[])new Object[0])).add(CreateLang.text((String)":")).space().add(CreateLang.number((double)this.getCurrentLensCount())).text("/").add(CreateLang.number((double)this.getLensLimit())).forGoggles(tooltip);
        for (ItemStack lensStack : this.getLenses()) {
            if (!lensStack.m_204117_(PropulsionItems.OPTICAL_LENS_TAG)) continue;
            if (lensStack.m_150930_((Item)PropulsionItems.OPTICAL_LENS.get())) {
                OpticalLensItem lensItem = (OpticalLensItem)lensStack.m_41720_();
                if (lensItem.m_41113_(lensStack)) {
                    MutableComponent coloredBox = Component.m_237113_((String)"\u2588").m_130948_(Style.f_131099_.m_178520_(lensItem.m_41121_(lensStack)));
                    GoggleUtils.LensTooltip(lensStack, tooltip).space().add((Component)coloredBox).forGoggles(tooltip);
                    continue;
                }
                GoggleUtils.LensTooltip(lensStack, tooltip).forGoggles(tooltip);
                continue;
            }
            GoggleUtils.LensTooltip(lensStack, tooltip).forGoggles(tooltip);
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.write(tag, true);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.read(tag, true);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("raycastDistance", this.raycastDistance);
        ListTag lensesTag = new ListTag();
        for (ItemStack stack : this.lenses) {
            lensesTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(NBT_LENSES_KEY, (Tag)lensesTag);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.raycastDistance = tag.m_128425_("raycastDistance", 5) ? tag.m_128457_("raycastDistance") : this.getMaxRaycastDistance();
        this.lenses = NonNullList.m_122780_((int)this.getLensLimit(), (Object)ItemStack.f_41583_);
        if (tag.m_128425_(NBT_LENSES_KEY, 9)) {
            ListTag lensesTag = tag.m_128437_(NBT_LENSES_KEY, 10);
            for (int i = 0; i < lensesTag.size(); ++i) {
                if (i >= this.lenses.size()) continue;
                CompoundTag itemTag = lensesTag.m_128728_(i);
                this.lenses.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
            }
        }
    }
}

