/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionItems;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class InlineOpticalSensorBlockEntity
extends AbstractOpticalSensorBlockEntity {
    private static final int LENS_LIMIT = 1;

    public InlineOpticalSensorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public float getZAxisOffset() {
        return -0.125f;
    }

    @Override
    public int getLensLimit() {
        return 1;
    }

    @Override
    protected float getMaxRaycastDistance() {
        boolean isFocused = this.hasLens((Item)PropulsionItems.FOCUS_LENS.get());
        boolean isUnfocused = this.hasLens((Item)PropulsionItems.UNFINISHED_LENS.get());
        return (float)((Integer)PropulsionConfig.INLINE_OPTICAL_SENSOR_MAX_DISTANCE.get()).intValue() * (isFocused ? 2.0f : 1.0f) * (isUnfocused ? 0.5f : 1.0f);
    }

    @Override
    protected void updateRedstoneSignal(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, int rawNewPower, @Nullable BlockPos hitBlockPos) {
        int finalPower = rawNewPower;
        int oldPower = (Integer)state.m_61143_((Property)AbstractOpticalSensorBlock.POWER);
        if (oldPower != finalPower) {
            BlockState updatedState = (BlockState)((BlockState)state.m_61124_((Property)AbstractOpticalSensorBlock.POWER, (Comparable)Integer.valueOf(finalPower))).m_61124_((Property)AbstractOpticalSensorBlock.POWERED, (Comparable)Boolean.valueOf(finalPower > 0));
            level.m_7731_(pos, updatedState, 3);
            Direction facingDir = (Direction)state.m_61143_((Property)AbstractOpticalSensorBlock.FACING);
            level.m_46672_(pos.m_121945_(facingDir.m_122424_()), state.m_60734_());
        }
    }
}

