/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.OpticalSensorBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionBlockEntities;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import javax.annotation.Nonnull;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OpticalSensorBlock
extends AbstractOpticalSensorBlock {
    private static final VoxelShaper INTERACTION_SHAPE = PropulsionShapes.ShapeBuilder.shape().add(Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)).forDirectional(Direction.NORTH);

    public OpticalSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new OpticalSensorBlockEntity((BlockEntityType)PropulsionBlockEntities.OPTICAL_SENSOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction baseDirection = context.m_7820_();
        Player player = context.m_43723_();
        Direction placeDirection = player != null ? (player.m_6144_() ? baseDirection : baseDirection.m_122424_()) : baseDirection.m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDirection)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @Override
    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            level.m_46672_(pos, state.m_60734_());
            level.m_46672_(pos.m_121945_(facing.m_122424_()), state.m_60734_());
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Override
    protected VoxelShaper getShapeMap() {
        return PropulsionShapes.OPTICAL_SENSOR;
    }

    @Override
    protected boolean isInteractionFace(BlockState state, BlockHitResult hit) {
        VoxelShape frontPartShape = INTERACTION_SHAPE.get((Direction)state.m_61143_((Property)FACING));
        Vec3 localHit = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_()));
        double epsilon = 1.0E-4;
        return frontPartShape.m_83299_().stream().anyMatch(aabb -> aabb.m_82400_(epsilon).m_82390_(localHit)) || hit.m_82434_() == state.m_61143_((Property)FACING);
    }

    @Override
    public int m_6378_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return ((Direction)blockState.m_61143_((Property)FACING)).m_122424_() == side ? 0 : (Integer)blockState.m_61143_((Property)POWER);
    }

    @Override
    public int m_6376_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_61143_((Property)FACING) == side ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }
}

