/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.particles;

import com.deltasf.createpropulsion.particles.PlumeParticleData;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="createpropulsion", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum ParticleTypes {
    PLUME(PlumeParticleData::new);

    private final ParticleEntry<?> entry;

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleTypes.registerFactories(event);
    }

    private <D extends ParticleOptions> ParticleTypes(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String name = CreateLang.asId((String)this.name());
        this.entry = new ParticleEntry(name, typeFactory);
    }

    public static ParticleType<?> getPlumeType() {
        return PLUME.get();
    }

    public static void register(IEventBus modEventBus) {
        ParticleEntry.REGISTER.register(modEventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (ParticleTypes particle : ParticleTypes.values()) {
            particle.entry.registerFactory(event);
        }
    }

    public ParticleType<?> get() {
        return (ParticleType)this.entry.object.get();
    }

    public String parameter() {
        return this.entry.name;
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"createpropulsion");
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final RegistryObject<ParticleType<D>> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = REGISTER.register(name, () -> this.typeFactory.get().createType());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(RegisterParticleProvidersEvent event) {
            this.typeFactory.get().register((ParticleType)this.object.get(), event);
        }
    }
}

