/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.particles;

import com.deltasf.createpropulsion.particles.PlumeParticleData;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PlumeParticle
extends SimpleAnimatedParticle {
    private static final float PLUME_SPREAD = 0.05f;
    private static final float PLUME_BASE_QUAD_SIZE = 2.0f;
    private static final float PLUME_FRICTION = 0.99f;
    private static final float PLUME_SPEED_MULTIPLIER = 0.144f;
    private static final int PLUME_BASE_LIFETIME = 40;
    private static final float SMOKE_SPREAD_MAGNITUDE = 0.15f;
    private static final float SMOKE_FRICTION = 0.96f;
    private static final float SMOKE_BASE_LIFt = 0.02f;
    private static final float COLLISION_SPEED_RETENTION = 0.9f;
    private static final double COLLISION_DETECTION_EPSILON = 0.001;
    private static final float COLLISION_PERPENDICULAR_DAMPEN = 0.1f;
    private final SpriteSet spriteSet;
    private static final int PLUME_SPRITE_COUNT = 6;
    private static final int SMOKE_SPRITE_COUNT = 7;
    private static final int BASE_SMOKE_TRANSITION_AGE = 20;
    private ParticleState currentState;
    private float currentSpeedMultiplier;
    private float currentFriction;
    private final int smokeTransitionAge;
    private final float smokeLift;
    private final Vec3 spreadDirection;
    private final float spreadMagnitude;
    private boolean hasCollided = false;
    double dx;
    double dy;
    double dz;
    float baseSize;

    protected PlumeParticle(ClientLevel level, double x, double y, double z, double dxSource, double dySource, double dzSource, SpriteSet spriteSet) {
        super(level, x, y, z, spriteSet, 0.0f);
        this.spriteSet = spriteSet;
        this.f_107663_ *= 2.0f;
        this.baseSize = this.f_107663_;
        this.f_107225_ = 40 + this.f_107223_.m_188503_(5);
        this.f_172258_ = 0.99f;
        this.dx = dxSource + (double)this.getRandomSpread();
        this.dy = dySource + (double)this.getRandomSpread();
        this.dz = dzSource + (double)this.getRandomSpread();
        this.f_107219_ = true;
        this.currentSpeedMultiplier = 0.144f;
        this.currentFriction = 0.99f;
        this.currentState = ParticleState.PLUME;
        Vec3 initialVel = new Vec3(this.dx, this.dy, this.dz).m_82541_();
        Vec3 nonParallel = new Vec3(1.0, 0.0, 0.0);
        if (Math.abs(initialVel.m_82526_(nonParallel)) > 0.99) {
            nonParallel = new Vec3(0.0, 1.0, 0.0);
        }
        Vec3 u = initialVel.m_82537_(nonParallel).m_82541_();
        Vec3 v = initialVel.m_82537_(u).m_82541_();
        double randomAngle = this.f_107223_.m_188500_() * 2.0 * Math.PI;
        this.spreadDirection = u.m_82490_(Math.cos(randomAngle)).m_82549_(v.m_82490_(Math.sin(randomAngle)));
        this.spreadMagnitude = 0.1f + this.f_107223_.m_188501_() * 0.7f;
        this.smokeTransitionAge = 20 + this.f_107223_.m_216332_(-2, 2);
        this.smokeLift = 0.01f + this.f_107223_.m_188501_() * 0.04f;
        this.m_108339_(this.spriteSet);
        this.m_107657_(0xFFFFFF);
        this.m_107271_(1.0f);
    }

    public void m_5989_() {
        Vec3 incomingVel;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        double COLLISION_IGNORE_DOT_THRESHOLD = -1.0E-5;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        double intendedMoveX = this.dx * (double)this.currentSpeedMultiplier;
        double intendedMoveY = this.dy * (double)this.currentSpeedMultiplier;
        double intendedMoveZ = this.dz * (double)this.currentSpeedMultiplier;
        double prevX = this.f_107212_;
        double prevY = this.f_107213_;
        double prevZ = this.f_107214_;
        this.m_6257_(intendedMoveX, intendedMoveY, intendedMoveZ);
        double actualMoveX = this.f_107212_ - prevX;
        double actualMoveY = this.f_107213_ - prevY;
        double actualMoveZ = this.f_107214_ - prevZ;
        boolean collisionDetected = false;
        Vec3 collisionNormal = null;
        if (this.f_107218_) {
            collisionDetected = true;
            collisionNormal = new Vec3(0.0, 1.0, 0.0);
        } else {
            boolean blockedYCeiling;
            float COLLISION_DETECTION_FACTOR = 0.95f;
            boolean blockedX = Math.abs(intendedMoveX) > 0.001 && Math.abs(actualMoveX) < Math.abs(intendedMoveX) * (double)0.95f;
            boolean blockedZ = Math.abs(intendedMoveZ) > 0.001 && Math.abs(actualMoveZ) < Math.abs(intendedMoveZ) * (double)0.95f;
            boolean bl = blockedYCeiling = Math.abs(intendedMoveY) > 0.001 && intendedMoveY > 0.0 && Math.abs(actualMoveY) < Math.abs(intendedMoveY) * (double)0.95f;
            if (blockedYCeiling) {
                collisionDetected = true;
                collisionNormal = new Vec3(0.0, -1.0, 0.0);
            } else if (blockedX) {
                collisionDetected = true;
                collisionNormal = new Vec3(intendedMoveX < 0.0 ? 1.0 : -1.0, 0.0, 0.0);
            } else if (blockedZ) {
                collisionDetected = true;
                collisionNormal = new Vec3(0.0, 0.0, intendedMoveZ < 0.0 ? 1.0 : -1.0);
            }
        }
        if (collisionDetected && collisionNormal != null && !((incomingVel = new Vec3(this.dx, this.dy, this.dz)).m_82541_().m_82526_(collisionNormal) > -1.0E-5)) {
            this.hasCollided = true;
            double incomingSpeedSq = incomingVel.m_82556_();
            if (incomingSpeedSq > 1.0E-7) {
                Vec3 axis2;
                Vec3 axis1;
                Vec3 incomingVelNormalized = incomingVel.m_82541_();
                double dot = incomingVelNormalized.m_82526_(collisionNormal);
                double angleOfIncidence = Math.acos(org.joml.Math.clamp((double)Math.abs(dot), (double)0.0, (double)1.0));
                float spreadBlendFactor = (float)Math.cos(angleOfIncidence);
                float slideBlendFactor = (float)Math.sin(angleOfIncidence);
                Vec3 V_normal_comp = collisionNormal.m_82490_(incomingVel.m_82526_(collisionNormal));
                Vec3 V_tangential_comp = incomingVel.m_82546_(V_normal_comp);
                Vec3 desiredNormalVel = incomingVel.m_82526_(collisionNormal) < 0.0 ? V_normal_comp.m_82490_((double)-0.1f) : V_normal_comp;
                double randomAngle = this.f_107223_.m_188500_() * Math.PI * 2.0;
                if (Math.abs(collisionNormal.f_82480_) > 0.9) {
                    axis1 = new Vec3(1.0, 0.0, 0.0).m_82541_();
                    axis2 = collisionNormal.m_82537_(axis1).m_82541_();
                } else {
                    axis1 = new Vec3(0.0, 1.0, 0.0).m_82541_();
                    axis2 = collisionNormal.m_82537_(axis1).m_82541_();
                }
                if (axis2.m_82556_() < 0.1) {
                    axis1 = Math.abs(collisionNormal.f_82479_) > 0.9 ? new Vec3(0.0, 0.0, 1.0).m_82541_() : new Vec3(1.0, 0.0, 0.0).m_82541_();
                    axis2 = collisionNormal.m_82537_(axis1).m_82541_();
                }
                Vec3 spreadPlaneDirection = axis1.m_82490_(Math.cos(randomAngle)).m_82549_(axis2.m_82490_(Math.sin(randomAngle))).m_82541_();
                Vec3 spreadComponent = spreadPlaneDirection.m_82490_(incomingVel.m_82553_() * (double)spreadBlendFactor);
                Vec3 slideComponent = V_tangential_comp.m_82490_((double)slideBlendFactor);
                Vec3 desiredTangentialVel = slideComponent.m_82549_(spreadComponent);
                Vec3 newVel = desiredNormalVel.m_82549_(desiredTangentialVel);
                double newVelMagnitude = newVel.m_82553_();
                if (newVelMagnitude > 1.0E-5) {
                    this.dx = newVel.f_82479_ / newVelMagnitude * incomingVel.m_82553_() * (double)0.9f;
                    this.dy = newVel.f_82480_ / newVelMagnitude * incomingVel.m_82553_() * (double)0.9f;
                    this.dz = newVel.f_82481_ / newVelMagnitude * incomingVel.m_82553_() * (double)0.9f;
                } else {
                    this.dx = spreadPlaneDirection.f_82479_ * incomingVel.m_82553_() * (double)0.9f * 0.5;
                    this.dy = spreadPlaneDirection.f_82480_ * incomingVel.m_82553_() * (double)0.9f * 0.5;
                    this.dz = spreadPlaneDirection.f_82481_ * incomingVel.m_82553_() * (double)0.9f * 0.5;
                }
            } else {
                this.dx *= 0.1;
                this.dy *= 0.1;
                this.dz *= 0.1;
            }
        }
        if (this.currentState == ParticleState.PLUME && this.f_107224_ >= this.smokeTransitionAge) {
            this.currentState = ParticleState.SMOKE;
            this.baseSize *= 1.2f;
            this.f_172258_ = 0.96f;
        }
        if (this.currentState == ParticleState.SMOKE) {
            this.dy += (double)this.smokeLift;
        }
        float percent = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107663_ = this.currentState == ParticleState.PLUME ? this.baseSize + (float)Math.pow(percent, 0.8f) * 2.0f : this.baseSize - percent * 2.0f + 2.5f;
        int presmokeAge = this.smokeTransitionAge - 5;
        if (this.f_107224_ >= presmokeAge && !this.hasCollided) {
            float smoke_percent = (this.f_107224_ - presmokeAge) / (this.f_107225_ - presmokeAge);
            float aged_spread_magnitude = (0.8f - smoke_percent) * this.spreadMagnitude;
            this.dx += this.spreadDirection.f_82479_ * (double)0.15f * (double)aged_spread_magnitude;
            this.dy += this.spreadDirection.f_82480_ * (double)0.15f * (double)aged_spread_magnitude;
            this.dz += this.spreadDirection.f_82481_ * (double)0.15f * (double)aged_spread_magnitude;
        }
        this.dx *= (double)this.currentFriction;
        this.dy *= (double)this.currentFriction;
        this.dz *= (double)this.currentFriction;
        this.pickSprite();
    }

    private void pickSprite() {
        int frameIndex;
        if (this.currentState == ParticleState.PLUME) {
            float plumeProgress = (float)this.f_107224_ / (float)this.smokeTransitionAge;
            int plumeFrame = (int)(plumeProgress * 6.0f);
            frameIndex = Mth.m_14045_((int)plumeFrame, (int)0, (int)5);
        } else {
            int ageInSmokePhase = this.f_107224_ - this.smokeTransitionAge;
            int smokePhaseDuration = this.f_107225_ - this.smokeTransitionAge;
            int smokeFrame = smokePhaseDuration <= 0 ? 0 : ageInSmokePhase * 7 / smokePhaseDuration;
            smokeFrame = Mth.m_14045_((int)smokeFrame, (int)0, (int)6);
            frameIndex = 6 + smokeFrame;
        }
        this.m_108337_(this.spriteSet.m_5819_(frameIndex, 13));
    }

    float getRandomSpread() {
        return (this.f_107223_.m_188501_() * 2.0f - 1.0f) * 0.05f;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    private static enum ParticleState {
        PLUME,
        SMOKE;

    }

    public static class Factory
    implements ParticleProvider<PlumeParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet plumeSpriteSet) {
            this.spriteSet = plumeSpriteSet;
        }

        public Particle createParticle(@Nonnull PlumeParticleData data, @Nonnull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new PlumeParticle(level, x, y, z, dx, dy, dz, this.spriteSet);
        }
    }
}

